/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.IVesselPositionMessage;
import dk.dma.ais.sentence.Vdm;
import dk.dma.enav.model.geometry.Position;

public abstract class AisPositionMessage
extends AisMessage
implements IVesselPositionMessage {
    private static final long serialVersionUID = 1L;
    protected int navStatus;
    protected int rot;
    protected int sog;
    protected int posAcc;
    protected AisPosition pos;
    protected int cog;
    protected int trueHeading;
    protected int utcSec;
    protected int specialManIndicator;
    protected int spare;
    protected int raim;
    protected int syncState;

    public AisPositionMessage(int msgId) {
        super(msgId);
    }

    public AisPositionMessage(Vdm vdm) {
        super(vdm);
    }

    @Override
    public void parse(BinArray binArray) throws AisMessageException, SixbitException {
        if (binArray.getLength() < 168) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + binArray.getLength());
        }
        super.parse(binArray);
        this.navStatus = (int)binArray.getVal(4);
        this.rot = (int)binArray.getVal(8);
        this.sog = (int)binArray.getVal(10);
        this.posAcc = (int)binArray.getVal(1);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(binArray.getVal(28));
        this.pos.setRawLatitude(binArray.getVal(27));
        this.cog = (int)binArray.getVal(12);
        this.trueHeading = (int)binArray.getVal(9);
        this.utcSec = (int)binArray.getVal(6);
        this.specialManIndicator = (int)binArray.getVal(2);
        this.spare = (int)binArray.getVal(3);
        this.raim = (int)binArray.getVal(1);
        this.syncState = (int)binArray.getVal(2);
    }

    @Override
    protected SixbitEncoder encode() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.navStatus, 4);
        encoder.addVal(this.rot, 8);
        encoder.addVal(this.sog, 10);
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.pos.getRawLongitude(), 28);
        encoder.addVal(this.pos.getRawLatitude(), 27);
        encoder.addVal(this.cog, 12);
        encoder.addVal(this.trueHeading, 9);
        encoder.addVal(this.utcSec, 6);
        encoder.addVal(this.specialManIndicator, 2);
        encoder.addVal(this.spare, 3);
        encoder.addVal(this.raim, 1);
        encoder.addVal(this.syncState, 2);
        return encoder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", cog=");
        builder.append(this.cog);
        builder.append(", navStatus=");
        builder.append(this.navStatus);
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", posAcc=");
        builder.append(this.posAcc);
        builder.append(", raim=");
        builder.append(this.raim);
        builder.append(", specialManIndicator=");
        builder.append(this.specialManIndicator);
        builder.append(", rot=");
        builder.append(this.rot);
        builder.append(", sog=");
        builder.append(this.sog);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", syncState=");
        builder.append(this.syncState);
        builder.append(", trueHeading=");
        builder.append(this.trueHeading);
        builder.append(", utcSec=");
        builder.append(this.utcSec);
        return builder.toString();
    }

    public int getNavStatus() {
        return this.navStatus;
    }

    public void setNavStatus(int navStatus) {
        this.navStatus = navStatus;
    }

    public int getRot() {
        return this.rot;
    }

    public Float getSensorRot() {
        if (this.rot == 128) {
            return null;
        }
        byte signedRot = (byte)this.rot;
        float sensorRot = (float)Math.pow((double)signedRot / 4.733, 2.0);
        if (signedRot < 0) {
            sensorRot *= -1.0f;
        }
        return Float.valueOf(sensorRot);
    }

    public void setRot(int rot) {
        this.rot = rot;
    }

    @Override
    public int getSog() {
        return this.sog;
    }

    public void setSog(int sog) {
        this.sog = sog;
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    @Override
    public final Position getValidPosition() {
        AisPosition pos = this.pos;
        return pos == null ? null : pos.getGeoLocation();
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    @Override
    public int getCog() {
        return this.cog;
    }

    public void setCog(int cog) {
        this.cog = cog;
    }

    @Override
    public int getTrueHeading() {
        return this.trueHeading;
    }

    public void setTrueHeading(int trueHeading) {
        this.trueHeading = trueHeading;
    }

    @Override
    public int getUtcSec() {
        return this.utcSec;
    }

    public void setUtcSec(int utcSec) {
        this.utcSec = utcSec;
    }

    public int getSpecialManIndicator() {
        return this.specialManIndicator;
    }

    public void setSpecialManIndicator(int specialManIndicator) {
        this.specialManIndicator = specialManIndicator;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    @Override
    public int getRaim() {
        return this.raim;
    }

    public void setRaim(int raim) {
        this.raim = raim;
    }

    public int getSyncState() {
        return this.syncState;
    }

    public void setSyncState(int syncState) {
        this.syncState = syncState;
    }

    @Override
    public boolean isPositionValid() {
        Position geo = this.pos.getGeoLocation();
        return geo != null;
    }

    @Override
    public boolean isCogValid() {
        return this.cog < 3600;
    }

    @Override
    public boolean isSogValid() {
        return this.sog < 1023;
    }

    @Override
    public boolean isHeadingValid() {
        return this.trueHeading < 360;
    }

    public boolean isRotValid() {
        return this.rot > -128;
    }
}

