/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

public enum NavigationalStatus {
    UNDER_WAY_USING_ENGINE(0),
    AT_ANCHOR(1),
    NOT_UNDER_COMMAND(2),
    RESTRICTED_MANOEUVRABILITY(3),
    CONSTRAINED_BY_HER_DRAUGHT(4),
    MOORED(5),
    AGROUND(6),
    ENGAGED_IN_FISHING(7),
    UNDER_WAY(8),
    UNDEFINED(15),
    AIS_SART(14){

        @Override
        public String prettyStatus() {
            return this.name().replace("_", "-");
        }
    };

    private final int code;

    private NavigationalStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static NavigationalStatus get(int intNavigationalStatus) {
        for (NavigationalStatus navigationalStatus : NavigationalStatus.values()) {
            if (intNavigationalStatus != navigationalStatus.code) continue;
            return navigationalStatus;
        }
        return UNDEFINED;
    }

    public String prettyStatus() {
        String navStat = this.name().replace("_", " ");
        return navStat.substring(0, 1) + navStat.substring(1).toLowerCase();
    }

    public String toString() {
        return this.prettyStatus();
    }
}

