/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.message.ShipTypeCargo;
import java.util.HashMap;
import java.util.Objects;

public enum ShipTypeColor {
    BLUE(ShipTypeCargo.ShipType.PASSENGER),
    GREY(ShipTypeCargo.ShipType.UNDEFINED, ShipTypeCargo.ShipType.UNKNOWN),
    GREEN(ShipTypeCargo.ShipType.CARGO),
    ORANGE(ShipTypeCargo.ShipType.FISHING),
    PURPLE(ShipTypeCargo.ShipType.SAILING, ShipTypeCargo.ShipType.PLEASURE),
    RED(ShipTypeCargo.ShipType.TANKER),
    TURQUOISE(new ShipTypeCargo.ShipType[0]),
    YELLOW(ShipTypeCargo.ShipType.HSC, ShipTypeCargo.ShipType.WIG);

    private static final HashMap<ShipTypeCargo.ShipType, ShipTypeColor> REVERSE_LOOKUP;
    private final ShipTypeCargo.ShipType[] shipTypes;

    private ShipTypeColor(ShipTypeCargo.ShipType ... shipTypes) {
        this.shipTypes = shipTypes;
    }

    public ShipTypeCargo.ShipType[] getShipTypes() {
        return this.shipTypes;
    }

    public static ShipTypeColor getColor(ShipTypeCargo.ShipType type) {
        ShipTypeColor c = REVERSE_LOOKUP.get((Object)Objects.requireNonNull(type));
        return c == null ? TURQUOISE : c;
    }

    static {
        REVERSE_LOOKUP = new HashMap();
        for (ShipTypeColor shipTypeColor : ShipTypeColor.values()) {
            for (ShipTypeCargo.ShipType shipType : shipTypeColor.shipTypes) {
                REVERSE_LOOKUP.put(shipType, shipTypeColor);
            }
        }
    }
}

