/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.IPositionMessage;
import dk.dma.ais.sentence.Vdm;
import dk.dma.enav.model.geometry.Position;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class UTCDateResponseMessage
extends AisMessage
implements IPositionMessage {
    private static final long serialVersionUID = 1L;
    private int utcYear;
    private int utcMonth;
    private int utcDay;
    private int utcHour;
    private int utcMinute;
    private int utcSecond;
    private int posAcc;
    private AisPosition pos;
    private int posType;
    private int transmissionControl;
    private int spare;
    private int raim;
    private int syncState;
    private int slotTimeout;
    private int subMessage;

    protected UTCDateResponseMessage(int msgId) {
        super(msgId);
    }

    public UTCDateResponseMessage(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() != 168) {
            throw new AisMessageException("Message 4 wrong length " + binArray.getLength() + " (should be 168)");
        }
        super.parse(binArray);
        this.utcYear = (int)binArray.getVal(14);
        this.utcMonth = (int)binArray.getVal(4);
        this.utcDay = (int)binArray.getVal(5);
        this.utcHour = (int)binArray.getVal(5);
        this.utcMinute = (int)binArray.getVal(6);
        this.utcSecond = (int)binArray.getVal(6);
        this.posAcc = (int)binArray.getVal(1);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(binArray.getVal(28));
        this.pos.setRawLatitude(binArray.getVal(27));
        this.posType = (int)binArray.getVal(4);
        this.transmissionControl = (int)binArray.getVal(1);
        this.spare = (int)binArray.getVal(9);
        this.raim = (int)binArray.getVal(1);
        this.syncState = (int)binArray.getVal(2);
        this.slotTimeout = (int)binArray.getVal(3);
        this.subMessage = (int)binArray.getVal(14);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.utcYear, 14);
        encoder.addVal(this.utcMonth, 4);
        encoder.addVal(this.utcDay, 5);
        encoder.addVal(this.utcHour, 5);
        encoder.addVal(this.utcMinute, 6);
        encoder.addVal(this.utcSecond, 6);
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.pos.getRawLongitude(), 28);
        encoder.addVal(this.pos.getRawLatitude(), 27);
        encoder.addVal(this.posType, 4);
        encoder.addVal(this.transmissionControl, 1);
        encoder.addVal(this.spare, 9);
        encoder.addVal(this.raim, 1);
        encoder.addVal(this.syncState, 2);
        encoder.addVal(this.slotTimeout, 3);
        encoder.addVal(this.subMessage, 14);
        return encoder;
    }

    public int getUtcYear() {
        return this.utcYear;
    }

    public void setUtcYear(int utcYear) {
        this.utcYear = utcYear;
    }

    public int getUtcMonth() {
        return this.utcMonth;
    }

    public void setUtcMonth(int utcMonth) {
        this.utcMonth = utcMonth;
    }

    public int getUtcDay() {
        return this.utcDay;
    }

    public void setUtcDay(int utcDay) {
        this.utcDay = utcDay;
    }

    public int getUtcHour() {
        return this.utcHour;
    }

    public void setUtcHour(int utcHour) {
        this.utcHour = utcHour;
    }

    public int getUtcMinute() {
        return this.utcMinute;
    }

    public void setUtcMinute(int utcMinute) {
        this.utcMinute = utcMinute;
    }

    public int getUtcSecond() {
        return this.utcSecond;
    }

    public void setUtcSecond(int utcSecond) {
        this.utcSecond = utcSecond;
    }

    public Date getDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.getUtcYear());
        cal.set(2, this.getUtcMonth() - 1);
        cal.set(5, this.getUtcDay());
        cal.set(11, this.getUtcHour());
        cal.set(12, this.getUtcMinute());
        cal.set(13, this.getUtcSecond());
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        return cal.getTime();
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    @Override
    public Position getValidPosition() {
        AisPosition pos = this.pos;
        return pos == null ? null : pos.getGeoLocation();
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    public int getPosType() {
        return this.posType;
    }

    public void setPosType(int posType) {
        this.posType = posType;
    }

    public int getTransmissionControl() {
        return this.transmissionControl;
    }

    public void setTransmissionControl(int transmissionControl) {
        this.transmissionControl = transmissionControl;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public int getRaim() {
        return this.raim;
    }

    public void setRaim(int raim) {
        this.raim = raim;
    }

    public int getSyncState() {
        return this.syncState;
    }

    public void setSyncState(int syncState) {
        this.syncState = syncState;
    }

    public int getSlotTimeout() {
        return this.slotTimeout;
    }

    public void setSlotTimeout(int slotTimeout) {
        this.slotTimeout = slotTimeout;
    }

    public int getSubMessage() {
        return this.subMessage;
    }

    public void setSubMessage(int subMessage) {
        this.subMessage = subMessage;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", posAcc=");
        builder.append(this.posAcc);
        builder.append(", posType=");
        builder.append(this.posType);
        builder.append(", raim=");
        builder.append(this.raim);
        builder.append(", slotTimeout=");
        builder.append(this.slotTimeout);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", subMessage=");
        builder.append(this.subMessage);
        builder.append(", syncState=");
        builder.append(this.syncState);
        builder.append(", utcDay=");
        builder.append(this.utcDay);
        builder.append(", utcHour=");
        builder.append(this.utcHour);
        builder.append(", utcMinute=");
        builder.append(this.utcMinute);
        builder.append(", utcMonth=");
        builder.append(this.utcMonth);
        builder.append(", utcSecond=");
        builder.append(this.utcSecond);
        builder.append(", utcYear=");
        builder.append(this.utcYear);
        builder.append(", date=");
        builder.append(this.getDate());
        builder.append("]");
        return builder.toString();
    }
}

