/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisBinaryMessage;
import dk.dma.ais.message.binary.AddressedAreaNotice;
import dk.dma.ais.message.binary.AddressedRouteInformation;
import dk.dma.ais.message.binary.AsmAcknowledge;
import dk.dma.ais.message.binary.BroadcastAreaNotice;
import dk.dma.ais.message.binary.BroadcastIntendedRoute;
import dk.dma.ais.message.binary.BroadcastRouteInformation;
import dk.dma.ais.message.binary.Capability;
import dk.dma.ais.message.binary.InlandVoyage;
import dk.dma.ais.message.binary.MetHyd11;
import dk.dma.ais.message.binary.MetHyd31;
import dk.dma.ais.message.binary.RouteSuggestion;
import dk.dma.ais.message.binary.RouteSuggestionReply;
import dk.dma.ais.message.binary.UnknownAsm;

public abstract class AisApplicationMessage {
    protected int dac;
    protected int fi;

    public AisApplicationMessage(int dac, int fi) {
        this.dac = dac;
        this.fi = fi;
    }

    public AisApplicationMessage(int dac, int fi, BinArray binArray) throws SixbitException {
        this.dac = dac;
        this.fi = fi;
        this.parse(binArray);
    }

    public abstract void parse(BinArray var1) throws SixbitException;

    public abstract SixbitEncoder getEncoded();

    public static AisApplicationMessage getInstance(AisBinaryMessage binaryMessage) throws SixbitException {
        if (binaryMessage.getFi() == 3) {
            return new Capability(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 5) {
            return new AsmAcknowledge(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 11) {
            return new MetHyd11(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 22) {
            return new BroadcastAreaNotice(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 23) {
            return new AddressedAreaNotice(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 27) {
            return new BroadcastRouteInformation(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 28) {
            return new AddressedRouteInformation(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 1 && binaryMessage.getFi() == 31) {
            return new MetHyd31(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 0 && binaryMessage.getFi() == 32) {
            return new RouteSuggestionReply(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 219 && binaryMessage.getFi() == 1) {
            return new BroadcastIntendedRoute(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 219 && binaryMessage.getFi() == 2) {
            return new RouteSuggestion(binaryMessage.getData());
        }
        if (binaryMessage.getDac() == 200 && binaryMessage.getFi() == 10) {
            return new InlandVoyage(binaryMessage.getData());
        }
        return new UnknownAsm(binaryMessage);
    }

    public int getDac() {
        return this.dac;
    }

    public int getFi() {
        return this.fi;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dac=");
        builder.append(this.dac);
        builder.append(", fi=");
        builder.append(this.fi);
        return builder.toString();
    }
}

