/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.binary.AisApplicationMessage;
import dk.dma.ais.message.binary.SubArea;
import java.util.ArrayList;
import java.util.List;

public abstract class AreaNotice
extends AisApplicationMessage {
    private int msgLinkId;
    private int notice;
    private int startMonth;
    private int startDay;
    private int startHour;
    private int startMin;
    private int duration;
    private int subareasCount;
    private List<SubArea> subareas;

    public AreaNotice(int fi) {
        super(1, fi);
        this.subareas = new ArrayList<SubArea>();
    }

    public AreaNotice(int fi, BinArray binArray) throws SixbitException {
        super(1, fi, binArray);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addVal(this.msgLinkId, 10);
        encoder.addVal(this.notice, 7);
        encoder.addVal(this.startMonth, 4);
        encoder.addVal(this.startDay, 5);
        encoder.addVal(this.startHour, 5);
        encoder.addVal(this.startMin, 6);
        encoder.addVal(this.duration, 18);
        for (SubArea subarea : this.subareas) {
            encoder.addVal(subarea.getRawAreaShape(), 3);
            switch (subarea.getRawAreaShape()) {
                case 0: {
                    encoder.addVal(subarea.getRawScaleFactor(), 2);
                    encoder.addVal(subarea.getRawLongitude(), 25);
                    encoder.addVal(subarea.getRawLatitude(), 24);
                    encoder.addVal(subarea.getRawPrecision(), 3);
                    encoder.addVal(subarea.getRawRadius(), 12);
                    encoder.addVal(subarea.getSpare(), 18);
                    break;
                }
                case 1: {
                    encoder.addVal(subarea.getRawScaleFactor(), 2);
                    encoder.addVal(subarea.getRawLongitude(), 25);
                    encoder.addVal(subarea.getRawLatitude(), 24);
                    encoder.addVal(subarea.getRawPrecision(), 3);
                    encoder.addVal(subarea.getRawEDim(), 8);
                    encoder.addVal(subarea.getRawNDim(), 8);
                    encoder.addVal(subarea.getRawOrient(), 9);
                    encoder.addVal(subarea.getSpare(), 5);
                    break;
                }
                case 2: {
                    encoder.addVal(subarea.getRawScaleFactor(), 2);
                    encoder.addVal(subarea.getRawLongitude(), 25);
                    encoder.addVal(subarea.getRawLatitude(), 24);
                    encoder.addVal(subarea.getRawPrecision(), 3);
                    encoder.addVal(subarea.getRawRadius(), 12);
                    encoder.addVal(subarea.getRawLeftBound(), 9);
                    encoder.addVal(subarea.getRawRightBound(), 9);
                    encoder.addVal(subarea.getSpare(), 0);
                    break;
                }
                case 3: {
                    encoder.addVal(subarea.getRawScaleFactor(), 2);
                    encoder.addVal(subarea.getRawP1Angle(), 10);
                    encoder.addVal(subarea.getRawP1Dist(), 10);
                    encoder.addVal(subarea.getRawP2Angle(), 10);
                    encoder.addVal(subarea.getRawP2Dist(), 10);
                    encoder.addVal(subarea.getRawP3Angle(), 10);
                    encoder.addVal(subarea.getRawP3Dist(), 10);
                    encoder.addVal(subarea.getRawP4Angle(), 10);
                    encoder.addVal(subarea.getRawP4Dist(), 10);
                    encoder.addVal(subarea.getSpare(), 2);
                    break;
                }
                case 4: {
                    encoder.addVal(subarea.getRawScaleFactor(), 2);
                    encoder.addVal(subarea.getRawP1Angle(), 10);
                    encoder.addVal(subarea.getRawP1Dist(), 10);
                    encoder.addVal(subarea.getRawP2Angle(), 10);
                    encoder.addVal(subarea.getRawP2Dist(), 10);
                    encoder.addVal(subarea.getRawP3Angle(), 10);
                    encoder.addVal(subarea.getRawP3Dist(), 10);
                    encoder.addVal(subarea.getRawP4Angle(), 10);
                    encoder.addVal(subarea.getRawP4Dist(), 10);
                    encoder.addVal(subarea.getSpare(), 2);
                    break;
                }
                case 5: {
                    encoder.addVal(subarea.getText(), 32);
                    encoder.addVal(subarea.getText1(), 32);
                    encoder.addVal(subarea.getText2(), 20);
                    break;
                }
            }
        }
        return encoder;
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        this.subareas = new ArrayList<SubArea>();
        this.msgLinkId = (int)binArray.getVal(10);
        this.notice = (int)binArray.getVal(7);
        this.startMonth = (int)binArray.getVal(4);
        this.startDay = (int)binArray.getVal(5);
        this.startHour = (int)binArray.getVal(5);
        this.startMin = (int)binArray.getVal(6);
        this.duration = (int)binArray.getVal(18);
        this.subareasCount = (binArray.getLength() - 111) / 87;
        for (int i = 0; i < this.subareasCount; ++i) {
            SubArea subarea = new SubArea();
            subarea.setRawAreaShape((int)binArray.getVal(3));
            switch (subarea.getRawAreaShape()) {
                case 0: {
                    subarea.setRawScaleFactor((int)binArray.getVal(2));
                    subarea.setRawLongitude((int)binArray.getVal(25));
                    subarea.setRawLatitude((int)binArray.getVal(24));
                    subarea.setRawPrecision((int)binArray.getVal(3));
                    subarea.setRawRadius((int)binArray.getVal(12));
                    subarea.setSpare((int)binArray.getVal(18));
                    break;
                }
                case 1: {
                    subarea.setRawScaleFactor((int)binArray.getVal(2));
                    subarea.setRawLongitude((int)binArray.getVal(25));
                    subarea.setRawLatitude((int)binArray.getVal(24));
                    subarea.setRawPrecision((int)binArray.getVal(3));
                    subarea.setRawEDim((int)binArray.getVal(8));
                    subarea.setRawNDim((int)binArray.getVal(8));
                    subarea.setRawOrient((int)binArray.getVal(9));
                    subarea.setSpare((int)binArray.getVal(5));
                    break;
                }
                case 2: {
                    subarea.setRawScaleFactor((int)binArray.getVal(2));
                    subarea.setRawLongitude((int)binArray.getVal(25));
                    subarea.setRawLatitude((int)binArray.getVal(24));
                    subarea.setRawPrecision((int)binArray.getVal(3));
                    subarea.setRawRadius((int)binArray.getVal(12));
                    subarea.setRawLeftBound((int)binArray.getVal(9));
                    subarea.setRawRightBound((int)binArray.getVal(9));
                    subarea.setSpare((int)binArray.getVal(0));
                    break;
                }
                case 3: {
                    subarea.setRawScaleFactor((int)binArray.getVal(2));
                    subarea.setRawP1Angle((int)binArray.getVal(10));
                    subarea.setRawP1Dist((int)binArray.getVal(10));
                    subarea.setRawP2Angle((int)binArray.getVal(10));
                    subarea.setRawP2Dist((int)binArray.getVal(10));
                    subarea.setRawP3Angle((int)binArray.getVal(10));
                    subarea.setRawP3Dist((int)binArray.getVal(10));
                    subarea.setRawP4Angle((int)binArray.getVal(10));
                    subarea.setRawP4Dist((int)binArray.getVal(10));
                    subarea.setSpare((int)binArray.getVal(2));
                    break;
                }
                case 4: {
                    subarea.setRawScaleFactor((int)binArray.getVal(2));
                    subarea.setRawP1Angle((int)binArray.getVal(10));
                    subarea.setRawP1Dist((int)binArray.getVal(10));
                    subarea.setRawP2Angle((int)binArray.getVal(10));
                    subarea.setRawP2Dist((int)binArray.getVal(10));
                    subarea.setRawP3Angle((int)binArray.getVal(10));
                    subarea.setRawP3Dist((int)binArray.getVal(10));
                    subarea.setRawP4Angle((int)binArray.getVal(10));
                    subarea.setRawP4Dist((int)binArray.getVal(10));
                    subarea.setSpare((int)binArray.getVal(2));
                    break;
                }
                case 5: {
                    subarea.setText((int)binArray.getVal(32));
                    subarea.setText1((int)binArray.getVal(32));
                    subarea.setText2((int)binArray.getVal(20));
                    break;
                }
            }
            this.subareas.add(subarea);
        }
    }

    public int getMsgLinkId() {
        return this.msgLinkId;
    }

    public void setMsgLinkId(int msgLinkId) {
        this.msgLinkId = msgLinkId;
    }

    public int getNotice() {
        return this.notice;
    }

    public void setNotice(int notice) {
        this.notice = notice;
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(int startMonth) {
        this.startMonth = startMonth;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public void setStartDay(int startDay) {
        this.startDay = startDay;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public void setStartHour(int startHour) {
        this.startHour = startHour;
    }

    public int getStartMin() {
        return this.startMin;
    }

    public void setStartMin(int startMin) {
        this.startMin = startMin;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setSubAreas(List<SubArea> subareas) {
        this.subareas = subareas;
    }

    public void addSubArea(SubArea subarea) {
        this.subareas.add(subarea);
        this.subareasCount = this.subareas.size();
    }

    public List<SubArea> getSubAreas() {
        return this.subareas;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", msgLinkId=");
        builder.append(this.msgLinkId);
        builder.append(", notice=");
        builder.append(this.notice);
        builder.append(", startDay=");
        builder.append(this.startDay);
        builder.append(", startHour=");
        builder.append(this.startHour);
        builder.append(", startMin=");
        builder.append(this.startMin);
        builder.append(", startMonth=");
        builder.append(this.startMonth);
        builder.append(", duration=");
        builder.append(this.duration);
        builder.append(", subareas=");
        builder.append(this.subareas);
        builder.append("]");
        return builder.toString();
    }

    public static enum SubAreaType {
        CIRCLE_OR_POINT(0),
        RECTANGLE(1),
        SECTOR(2),
        POLYLINE(3),
        POLYGON(4),
        TEXT(5),
        RESERVED(6),
        RESERVED2(7);

        private int astype;

        private SubAreaType(int astype) {
            this.astype = astype;
        }

        public int getType() {
            return this.astype;
        }
    }
}

