/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.binary.AisApplicationMessage;

public class AsmAcknowledge
extends AisApplicationMessage {
    private int receivedDac;
    private int receivedFi;
    private int textSequenceNum;
    private int aiAvailable;
    private int aiResponse;
    private int spare;

    public AsmAcknowledge() {
        super(1, 5);
    }

    public AsmAcknowledge(BinArray binArray) throws SixbitException {
        super(1, 5, binArray);
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        this.receivedDac = (int)binArray.getVal(10);
        this.receivedFi = (int)binArray.getVal(6);
        this.textSequenceNum = (int)binArray.getVal(11);
        this.aiAvailable = (int)binArray.getVal(1);
        this.aiResponse = (int)binArray.getVal(3);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addVal(this.receivedDac, 10);
        encoder.addVal(this.receivedFi, 6);
        encoder.addVal(this.textSequenceNum, 11);
        encoder.addVal(this.aiAvailable, 1);
        encoder.addVal(this.aiResponse, 3);
        encoder.addVal(0L, 49);
        return encoder;
    }

    public int getReceivedDac() {
        return this.receivedDac;
    }

    public void setReceivedDac(int receivedDac) {
        this.receivedDac = receivedDac;
    }

    public int getReceivedFi() {
        return this.receivedFi;
    }

    public void setReceivedFi(int receivedFi) {
        this.receivedFi = receivedFi;
    }

    public int getTextSequenceNum() {
        return this.textSequenceNum;
    }

    public void setTextSequenceNum(int textSequenceNum) {
        this.textSequenceNum = textSequenceNum;
    }

    public int getAiAvailable() {
        return this.aiAvailable;
    }

    public void setAiAvailable(int aiAvailable) {
        this.aiAvailable = aiAvailable;
    }

    public int getAiResponse() {
        return this.aiResponse;
    }

    public void setAiResponse(int aiResponse) {
        this.aiResponse = aiResponse;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", aiAvailable=");
        builder.append(this.aiAvailable);
        builder.append(", aiResponse=");
        builder.append(this.aiResponse);
        builder.append(", receivedDac=");
        builder.append(this.receivedDac);
        builder.append(", receivedFi=");
        builder.append(this.receivedFi);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", textSequenceNum=");
        builder.append(this.textSequenceNum);
        builder.append("]");
        return builder.toString();
    }
}

