/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.binary.AisApplicationMessage;

public class InlandVoyage
extends AisApplicationMessage {
    private String vesselId;
    private int lengthOfShip;
    private int beamOfShip;
    private int combinationType;
    private int hazardousCargo;
    private int draught;
    private int loadedOrUnloaded;
    private int qualityOfSpeedData;
    private int qualityOfCourseData;
    private int qualityOfHeadingData;
    private int spare;

    public InlandVoyage(BinArray binArray) throws SixbitException {
        super(200, 10, binArray);
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        StringBuilder vesselIdBuilder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            int value = (int)binArray.getVal(6);
            vesselIdBuilder.append((char)value);
        }
        this.vesselId = vesselIdBuilder.toString();
        this.vesselId = this.vesselId.replaceAll("[^\\d.]", "");
        this.lengthOfShip = (int)binArray.getVal(13);
        this.beamOfShip = (int)binArray.getVal(10);
        this.combinationType = (int)binArray.getVal(14);
        this.hazardousCargo = (int)binArray.getVal(3);
        this.draught = (int)binArray.getVal(11);
        this.loadedOrUnloaded = (int)binArray.getVal(2);
        this.qualityOfSpeedData = (int)binArray.getVal(1);
        this.qualityOfCourseData = (int)binArray.getVal(1);
        this.qualityOfHeadingData = (int)binArray.getVal(1);
        this.spare = (int)binArray.getVal(8);
    }

    @Override
    public SixbitEncoder getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[InlandVoyage: lengthOfShip=");
        builder.append(this.lengthOfShip);
        builder.append(", beamOfShip=");
        builder.append(this.beamOfShip);
        builder.append(", combinationType=");
        builder.append(this.combinationType);
        builder.append(", hazardousCargo=");
        builder.append(this.hazardousCargo);
        builder.append(", draught=");
        builder.append(this.draught);
        builder.append(", loadedOrUnloaded=");
        builder.append(this.loadedOrUnloaded);
        builder.append(", qualityOfSpeedData=");
        builder.append(this.qualityOfSpeedData);
        builder.append(", qualityOfCourseData=");
        builder.append(this.qualityOfCourseData);
        builder.append(", qualityOfHeadingData=");
        builder.append(this.qualityOfHeadingData);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", vesselId=");
        builder.append(this.vesselId);
        builder.append("]");
        return builder.toString();
    }

    public int getLengthOfShip() {
        return this.lengthOfShip;
    }

    public void setLengthOfShip(int lengthOfShip) {
        this.lengthOfShip = lengthOfShip;
    }

    public int getBeamOfShip() {
        return this.beamOfShip;
    }

    public void setBeamOfShip(int beamOfShip) {
        this.beamOfShip = beamOfShip;
    }

    public int getCombinationType() {
        return this.combinationType;
    }

    public void setCombinationType(int combinationType) {
        this.combinationType = combinationType;
    }

    public int getHazardousCargo() {
        return this.hazardousCargo;
    }

    public void setHazardousCargo(int hazardousCargo) {
        this.hazardousCargo = hazardousCargo;
    }

    public int getDraught() {
        return this.draught;
    }

    public void setDraught(int draught) {
        this.draught = draught;
    }

    public int getLoadedOrUnloaded() {
        return this.loadedOrUnloaded;
    }

    public void setLoadedOrUnloaded(int loadedOrUnloaded) {
        this.loadedOrUnloaded = loadedOrUnloaded;
    }

    public int getQualityOfSpeedData() {
        return this.qualityOfSpeedData;
    }

    public void setQualityOfSpeedData(int qualityOfSpeedData) {
        this.qualityOfSpeedData = qualityOfSpeedData;
    }

    public int getQualityOfCourseData() {
        return this.qualityOfCourseData;
    }

    public void setQualityOfCourseData(int qualityOfCourseData) {
        this.qualityOfCourseData = qualityOfCourseData;
    }

    public int getQualityOfHeadingData() {
        return this.qualityOfHeadingData;
    }

    public void setQualityOfHeadingData(int qualityOfHeadingData) {
        this.qualityOfHeadingData = qualityOfHeadingData;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public String getVesselId() {
        return this.vesselId;
    }

    public void setVesselId(String vesselId) {
        this.vesselId = vesselId;
    }
}

