/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.binary.AisApplicationMessage;

public class MetHyd11
extends AisApplicationMessage {
    private AisPosition pos;
    private int utcDay;
    private int utcHour;
    private int utcMinute;
    private int wind;
    private int gust;
    private int windDirection;
    private int gustDirection;
    private int airTemp;
    private int humidity;
    private int dewPoint;
    private int airPressure;
    private int airPressureTend;
    private int horzVisibility;
    private int waterLevel;
    private int waterLevelTrend;
    private int surfaceCurrent;
    private int surfaceCurrentDir;
    private int secondCurrent;
    private int secondCurrentDir;
    private int secondCurrentLevel;
    private int thirdCurrent;
    private int thirdCurrentDir;
    private int thirdCurrentLevel;
    private int waveHeight;
    private int wavePeriod;
    private int waveDirection;
    private int swellHeight;
    private int swellPeriod;
    private int swellDirection;
    private int seaState;
    private int waterTemp;
    private int precipitation;
    private int salinity;
    private int ice;
    private int spare;

    public MetHyd11(BinArray binArray) throws SixbitException {
        super(1, 11, binArray);
    }

    @Override
    public SixbitEncoder getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        this.pos = new AisPosition();
        this.pos.set2524();
        this.pos.setRawLatitude(binArray.getVal(24));
        this.pos.setRawLongitude(binArray.getVal(25));
        this.utcDay = (int)binArray.getVal(5);
        this.utcHour = (int)binArray.getVal(5);
        this.utcMinute = (int)binArray.getVal(6);
        this.wind = (int)binArray.getVal(7);
        this.gust = (int)binArray.getVal(7);
        this.windDirection = (int)binArray.getVal(9);
        this.gustDirection = (int)binArray.getVal(9);
        this.airTemp = (int)binArray.getVal(11);
        this.humidity = (int)binArray.getVal(7);
        this.dewPoint = (int)binArray.getVal(10);
        this.airPressure = (int)binArray.getVal(9);
        this.airPressureTend = (int)binArray.getVal(2);
        this.horzVisibility = (int)binArray.getVal(8);
        this.waterLevel = (int)binArray.getVal(9);
        this.waterLevelTrend = (int)binArray.getVal(2);
        this.surfaceCurrent = (int)binArray.getVal(8);
        this.surfaceCurrentDir = (int)binArray.getVal(9);
        this.secondCurrent = (int)binArray.getVal(8);
        this.secondCurrentDir = (int)binArray.getVal(9);
        this.secondCurrentLevel = (int)binArray.getVal(5);
        this.thirdCurrent = (int)binArray.getVal(8);
        this.thirdCurrentDir = (int)binArray.getVal(9);
        this.thirdCurrentLevel = (int)binArray.getVal(5);
        this.waveHeight = (int)binArray.getVal(8);
        this.wavePeriod = (int)binArray.getVal(6);
        this.waveDirection = (int)binArray.getVal(9);
        this.swellHeight = (int)binArray.getVal(8);
        this.swellPeriod = (int)binArray.getVal(6);
        this.swellDirection = (int)binArray.getVal(9);
        this.seaState = (int)binArray.getVal(4);
        this.waterTemp = (int)binArray.getVal(10);
        this.precipitation = (int)binArray.getVal(3);
        this.salinity = (int)binArray.getVal(9);
        this.ice = (int)binArray.getVal(2);
        this.spare = (int)binArray.getVal(6);
    }

    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    public int getUtcDay() {
        return this.utcDay;
    }

    public void setUtcDay(int utcDay) {
        this.utcDay = utcDay;
    }

    public int getUtcHour() {
        return this.utcHour;
    }

    public void setUtcHour(int utcHour) {
        this.utcHour = utcHour;
    }

    public int getUtcMinute() {
        return this.utcMinute;
    }

    public void setUtcMinute(int utcMinute) {
        this.utcMinute = utcMinute;
    }

    public int getWind() {
        return this.wind;
    }

    public void setWind(int wind) {
        this.wind = wind;
    }

    public int getGust() {
        return this.gust;
    }

    public void setGust(int gust) {
        this.gust = gust;
    }

    public int getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(int windDirection) {
        this.windDirection = windDirection;
    }

    public int getGustDirection() {
        return this.gustDirection;
    }

    public void setGustDirection(int gustDirection) {
        this.gustDirection = gustDirection;
    }

    public int getAirTemp() {
        return this.airTemp;
    }

    public void setAirTemp(int airTemp) {
        this.airTemp = airTemp;
    }

    public int getHumidity() {
        return this.humidity;
    }

    public void setHumidity(int humidity) {
        this.humidity = humidity;
    }

    public int getDewPoint() {
        return this.dewPoint;
    }

    public void setDewPoint(int dewPoint) {
        this.dewPoint = dewPoint;
    }

    public int getAirPressure() {
        return this.airPressure;
    }

    public void setAirPressure(int airPressure) {
        this.airPressure = airPressure;
    }

    public int getAirPressureTend() {
        return this.airPressureTend;
    }

    public void setAirPressureTend(int airPressureTend) {
        this.airPressureTend = airPressureTend;
    }

    public int getHorzVisibility() {
        return this.horzVisibility;
    }

    public void setHorzVisibility(int horzVisibility) {
        this.horzVisibility = horzVisibility;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    public int getWaterLevelTrend() {
        return this.waterLevelTrend;
    }

    public void setWaterLevelTrend(int waterLevelTrend) {
        this.waterLevelTrend = waterLevelTrend;
    }

    public int getSurfaceCurrent() {
        return this.surfaceCurrent;
    }

    public void setSurfaceCurrent(int surfaceCurrent) {
        this.surfaceCurrent = surfaceCurrent;
    }

    public int getSurfaceCurrentDir() {
        return this.surfaceCurrentDir;
    }

    public void setSurfaceCurrentDir(int surfaceCurrentDir) {
        this.surfaceCurrentDir = surfaceCurrentDir;
    }

    public int getSecondCurrent() {
        return this.secondCurrent;
    }

    public void setSecondCurrent(int secondCurrent) {
        this.secondCurrent = secondCurrent;
    }

    public int getSecondCurrentDir() {
        return this.secondCurrentDir;
    }

    public void setSecondCurrentDir(int secondCurrentDir) {
        this.secondCurrentDir = secondCurrentDir;
    }

    public int getSecondCurrentLevel() {
        return this.secondCurrentLevel;
    }

    public void setSecondCurrentLevel(int secondCurrentLevel) {
        this.secondCurrentLevel = secondCurrentLevel;
    }

    public int getThirdCurrent() {
        return this.thirdCurrent;
    }

    public void setThirdCurrent(int thirdCurrent) {
        this.thirdCurrent = thirdCurrent;
    }

    public int getThirdCurrentDir() {
        return this.thirdCurrentDir;
    }

    public void setThirdCurrentDir(int thirdCurrentDir) {
        this.thirdCurrentDir = thirdCurrentDir;
    }

    public int getThirdCurrentLevel() {
        return this.thirdCurrentLevel;
    }

    public void setThirdCurrentLevel(int thirdCurrentLevel) {
        this.thirdCurrentLevel = thirdCurrentLevel;
    }

    public int getWaveHeight() {
        return this.waveHeight;
    }

    public void setWaveHeight(int waveHeight) {
        this.waveHeight = waveHeight;
    }

    public int getWavePeriod() {
        return this.wavePeriod;
    }

    public void setWavePeriod(int wavePeriod) {
        this.wavePeriod = wavePeriod;
    }

    public int getWaveDirection() {
        return this.waveDirection;
    }

    public void setWaveDirection(int waveDirection) {
        this.waveDirection = waveDirection;
    }

    public int getSwellHeight() {
        return this.swellHeight;
    }

    public void setSwellHeight(int swellHeight) {
        this.swellHeight = swellHeight;
    }

    public int getSwellPeriod() {
        return this.swellPeriod;
    }

    public void setSwellPeriod(int swellPeriod) {
        this.swellPeriod = swellPeriod;
    }

    public int getSwellDirection() {
        return this.swellDirection;
    }

    public void setSwellDirection(int swellDirection) {
        this.swellDirection = swellDirection;
    }

    public int getSeaState() {
        return this.seaState;
    }

    public void setSeaState(int seaState) {
        this.seaState = seaState;
    }

    public int getWaterTemp() {
        return this.waterTemp;
    }

    public void setWaterTemp(int waterTemp) {
        this.waterTemp = waterTemp;
    }

    public int getPrecipitation() {
        return this.precipitation;
    }

    public void setPrecipitation(int precipitation) {
        this.precipitation = precipitation;
    }

    public int getSalinity() {
        return this.salinity;
    }

    public void setSalinity(int salinity) {
        this.salinity = salinity;
    }

    public int getIce() {
        return this.ice;
    }

    public void setIce(int ice) {
        this.ice = ice;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[MetHyd11: airPressure=");
        builder.append(this.airPressure);
        builder.append(", airPressureTend=");
        builder.append(this.airPressureTend);
        builder.append(", airTemp=");
        builder.append(this.airTemp);
        builder.append(", dewPoint=");
        builder.append(this.dewPoint);
        builder.append(", gust=");
        builder.append(this.gust);
        builder.append(", gustDirection=");
        builder.append(this.gustDirection);
        builder.append(", horzVisibility=");
        builder.append(this.horzVisibility);
        builder.append(", humidity=");
        builder.append(this.humidity);
        builder.append(", ice=");
        builder.append(this.ice);
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", precipitation=");
        builder.append(this.precipitation);
        builder.append(", salinity=");
        builder.append(this.salinity);
        builder.append(", seaState=");
        builder.append(this.seaState);
        builder.append(", secondCurrent=");
        builder.append(this.secondCurrent);
        builder.append(", secondCurrentDir=");
        builder.append(this.secondCurrentDir);
        builder.append(", secondCurrentLevel=");
        builder.append(this.secondCurrentLevel);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", surfaceCurrent=");
        builder.append(this.surfaceCurrent);
        builder.append(", surfaceCurrentDir=");
        builder.append(this.surfaceCurrentDir);
        builder.append(", swellDirection=");
        builder.append(this.swellDirection);
        builder.append(", swellHeight=");
        builder.append(this.swellHeight);
        builder.append(", swellPeriod=");
        builder.append(this.swellPeriod);
        builder.append(", thirdCurrent=");
        builder.append(this.thirdCurrent);
        builder.append(", thirdCurrentDir=");
        builder.append(this.thirdCurrentDir);
        builder.append(", thirdCurrentLevel=");
        builder.append(this.thirdCurrentLevel);
        builder.append(", utcDay=");
        builder.append(this.utcDay);
        builder.append(", utcHour=");
        builder.append(this.utcHour);
        builder.append(", utcMinute=");
        builder.append(this.utcMinute);
        builder.append(", waterLevel=");
        builder.append(this.waterLevel);
        builder.append(", waterLevelTrend=");
        builder.append(this.waterLevelTrend);
        builder.append(", waterTemp=");
        builder.append(this.waterTemp);
        builder.append(", waveDirection=");
        builder.append(this.waveDirection);
        builder.append(", waveHeight=");
        builder.append(this.waveHeight);
        builder.append(", wavePeriod=");
        builder.append(this.wavePeriod);
        builder.append(", wind=");
        builder.append(this.wind);
        builder.append(", windDirection=");
        builder.append(this.windDirection);
        builder.append("]");
        return builder.toString();
    }
}

