/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.binary.RouteMessage;
import java.util.ArrayList;

public abstract class RouteInformation
extends RouteMessage {
    private int msgLinkId;
    private int senderClassification;
    private int routeType;

    public RouteInformation(int dac, int fi) {
        super(dac, fi);
        this.waypoints = new ArrayList();
    }

    public RouteInformation(int dac, int fi, BinArray binArray) throws SixbitException {
        super(dac, fi, binArray);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addVal(this.msgLinkId, 10);
        encoder.addVal(this.senderClassification, 3);
        encoder.addVal(this.routeType, 5);
        super.encode(encoder);
        return encoder;
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        this.waypoints = new ArrayList();
        this.msgLinkId = (int)binArray.getVal(10);
        this.senderClassification = (int)binArray.getVal(3);
        this.routeType = (int)binArray.getVal(5);
        super.parse(binArray);
    }

    public int getMsgLinkId() {
        return this.msgLinkId;
    }

    public void setMsgLinkId(int msgLinkId) {
        this.msgLinkId = msgLinkId;
    }

    public int getSenderClassification() {
        return this.senderClassification;
    }

    public void setSenderClassification(int senderClassification) {
        this.senderClassification = senderClassification;
    }

    public int getRouteType() {
        return this.routeType;
    }

    public void setRouteType(int routeType) {
        this.routeType = routeType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", msgLinkId=");
        builder.append(this.msgLinkId);
        builder.append(", routeType=");
        builder.append(this.routeType);
        builder.append(", senderClassification=");
        builder.append(this.senderClassification);
        return builder.toString();
    }

    public static enum RouteType {
        NOT_AVAIABLE(0),
        MANDATORY(1),
        RECOMMENDED(2),
        ALTERNATIVE(3),
        RECOMMENDED_THROUGH_ICE(4),
        SHIP_ROUTE(5),
        CANCELLATION(31);

        private int type;

        private RouteType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

