/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.binary.AisApplicationMessage;
import java.util.ArrayList;
import java.util.List;

public abstract class RouteMessage
extends AisApplicationMessage {
    protected int startMonth;
    protected int startDay;
    protected int startHour;
    protected int startMin;
    protected int duration;
    protected int waypointCount;
    protected List<AisPosition> waypoints;

    public RouteMessage(int dac, int fi) {
        super(dac, fi);
        this.waypoints = new ArrayList<AisPosition>();
    }

    public RouteMessage(int dac, int fi, BinArray binArray) throws SixbitException {
        super(dac, fi, binArray);
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        this.waypoints = new ArrayList<AisPosition>();
        this.startMonth = (int)binArray.getVal(4);
        this.startDay = (int)binArray.getVal(5);
        this.startHour = (int)binArray.getVal(5);
        this.startMin = (int)binArray.getVal(6);
        this.duration = (int)binArray.getVal(18);
        this.waypointCount = (int)binArray.getVal(5);
        for (int i = 0; i < this.waypointCount; ++i) {
            AisPosition waypoint = new AisPosition();
            waypoint.setRawLongitude(binArray.getVal(28));
            waypoint.setRawLatitude(binArray.getVal(27));
            this.waypoints.add(waypoint);
        }
    }

    public void encode(SixbitEncoder encoder) {
        encoder.addVal(this.startMonth, 4);
        encoder.addVal(this.startDay, 5);
        encoder.addVal(this.startHour, 5);
        encoder.addVal(this.startMin, 6);
        encoder.addVal(this.duration, 18);
        encoder.addVal(this.waypointCount, 5);
        for (AisPosition waypoint : this.waypoints) {
            encoder.addVal(waypoint.getRawLongitude(), 28);
            encoder.addVal(waypoint.getRawLatitude(), 27);
        }
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = new SixbitEncoder();
        this.encode(encoder);
        return encoder;
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(int startMonth) {
        this.startMonth = startMonth;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public void setStartDay(int startDay) {
        this.startDay = startDay;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public void setStartHour(int startHour) {
        this.startHour = startHour;
    }

    public int getStartMin() {
        return this.startMin;
    }

    public void setStartMin(int startMin) {
        this.startMin = startMin;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getWaypointCount() {
        return this.waypointCount;
    }

    public void setWaypointCount(int waypointCount) {
        this.waypointCount = waypointCount;
    }

    public List<AisPosition> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<AisPosition> waypoints) {
        this.waypoints = waypoints;
    }

    public void addWaypoint(AisPosition waypoint) {
        this.waypoints.add(waypoint);
        this.waypointCount = this.waypoints.size();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", startMonth=");
        builder.append(this.startMonth);
        builder.append(", startDay=");
        builder.append(this.startDay);
        builder.append(", startHour=");
        builder.append(this.startHour);
        builder.append(", startMin=");
        builder.append(this.startMin);
        builder.append(", duration=");
        builder.append(this.duration);
        builder.append(", waypointCount=");
        builder.append(this.waypointCount);
        builder.append(", waypoints=");
        builder.append(this.waypoints);
        builder.append("]");
        return builder.toString();
    }
}

