/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.binary.RouteExchange;
import java.util.ArrayList;

public class RouteSuggestion
extends RouteExchange {
    public static final int DAC = 219;
    public static final int FI = 2;
    private int msgLinkId;
    private int routeType;

    public RouteSuggestion() {
        super(219, 2);
    }

    public RouteSuggestion(BinArray binArray) throws SixbitException {
        super(219, 2, binArray);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addVal(this.msgLinkId, 10);
        encoder.addVal(this.routeType, 5);
        super.encode(encoder);
        return encoder;
    }

    @Override
    public void parse(BinArray binArray) throws SixbitException {
        this.waypoints = new ArrayList();
        this.msgLinkId = (int)binArray.getVal(10);
        this.routeType = (int)binArray.getVal(5);
        super.parse(binArray);
    }

    public int getMsgLinkId() {
        return this.msgLinkId;
    }

    public void setMsgLinkId(int msgLinkId) {
        this.msgLinkId = msgLinkId;
    }

    public int getRouteType() {
        return this.routeType;
    }

    public void setRouteType(int routeType) {
        this.routeType = routeType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RouteSuggestion [");
        builder.append(super.toString());
        builder.append(", msgLinkId=");
        builder.append(this.msgLinkId);
        builder.append(", routeType=");
        builder.append(this.routeType);
        return builder.toString();
    }

    public static enum RouteType {
        MANDATORY(1),
        RECOMMENDED(2),
        ALTERNATIVE(3);

        private int type;

        private RouteType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

