/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.proprietary;

import dk.dma.ais.proprietary.IProprietaryTag;
import dk.dma.ais.sentence.SentenceLine;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public abstract class ProprietaryFactory {
    static Map<String, ProprietaryFactory> ALL_FACTORIES;
    private final String prefix;

    public ProprietaryFactory(String prefix) {
        this.prefix = Objects.requireNonNull(prefix);
        if (prefix.length() != 3) {
            throw new IllegalArgumentException("Prefix length must be exactly 3, was '" + prefix + "'");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public abstract IProprietaryTag getTag(SentenceLine var1);

    public static Collection<ProprietaryFactory> getAllFactories() {
        return ALL_FACTORIES.values();
    }

    public static IProprietaryTag parseTag(SentenceLine sl) {
        ProprietaryFactory psf = ProprietaryFactory.match(sl.getSentenceHead());
        return psf == null ? null : psf.getTag(sl);
    }

    public static boolean isProprietaryTag(String line) {
        return line != null && line.length() >= 5 && line.startsWith("$P");
    }

    public static ProprietaryFactory match(String line) {
        if (ProprietaryFactory.isProprietaryTag(line)) {
            String p = line.substring(2, 5);
            return ALL_FACTORIES.get(p);
        }
        return null;
    }

    static {
        HashMap<String, ProprietaryFactory> map = new HashMap<String, ProprietaryFactory>();
        for (ProprietaryFactory f : ServiceLoader.load(ProprietaryFactory.class)) {
            map.put(f.prefix, f);
        }
        ALL_FACTORIES = Collections.unmodifiableMap(map);
    }
}

