/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.sentence.ParametricSentence;
import dk.dma.ais.sentence.Sentence;
import dk.dma.ais.sentence.SentenceException;
import dk.dma.ais.sentence.SentenceLine;

public class Abk
extends ParametricSentence {
    private int destination = 0;
    private Character channel;
    private int msgId;
    private int sequence;
    private Result result;

    public Abk() {
        this.formatter = "ABK";
    }

    public static boolean isAbk(String line) {
        return line.indexOf("$AIABK") >= 0;
    }

    @Override
    public int parse(SentenceLine sl) throws SentenceException {
        super.baseParse(sl);
        if (!this.formatter.equals("ABK")) {
            throw new SentenceException("Not ABK sentence");
        }
        if (sl.getFields().size() < 5) {
            throw new SentenceException("Sentence does not have at least 5 fields");
        }
        if (sl.getFields().get(1).length() > 0) {
            this.destination = Sentence.parseInt(sl.getFields().get(1));
        }
        this.channel = sl.getFields().get(2).length() > 0 ? Character.valueOf(sl.getFields().get(2).charAt(0)) : Character.valueOf('\u0000');
        this.msgId = Sentence.parseInt(sl.getFields().get(3));
        this.sequence = Sentence.parseInt(sl.getFields().get(4));
        this.result = Result.parseInt(Sentence.parseInt(sl.getFields().get(5)));
        return 0;
    }

    @Override
    public String getEncoded() {
        super.encode();
        this.encodedFields.set(0, "$AIABK");
        this.encodedFields.add(this.destination == 0 ? "" : Integer.toString(this.destination));
        this.encodedFields.add(this.channel == null ? "" : Character.toString(this.channel.charValue()));
        this.encodedFields.add(Integer.toString(this.msgId));
        this.encodedFields.add(Integer.toString(this.sequence));
        this.encodedFields.add(Integer.toString(this.result.getRes()));
        return this.finalEncode();
    }

    public boolean isSuccess() {
        return this.getResult() == Result.ADDRESSED_SUCCESS || this.getResult() == Result.BROADCAST_SENT;
    }

    public int getDestination() {
        return this.destination;
    }

    public void setDestination(int destination) {
        this.destination = destination;
    }

    public Character getChannel() {
        return this.channel;
    }

    public void setChannel(Character channel) {
        this.channel = channel;
    }

    public int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Abk [channel=");
        builder.append(this.channel);
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append(", msgId=");
        builder.append(this.msgId);
        builder.append(", result=");
        builder.append((Object)this.result);
        builder.append(", sequence=");
        builder.append(this.sequence);
        builder.append("]");
        return builder.toString();
    }

    public static enum Result {
        ADDRESSED_SUCCESS(0),
        ADDRESSED_NO_ACKNOWLEDGE(1),
        COULD_NOT_BROADCAST(2),
        BROADCAST_SENT(3),
        LATE_RECEPTION(4);

        private int res;

        private Result(int res) {
            this.res = res;
        }

        public int getRes() {
            return this.res;
        }

        public static Result parseInt(int res) {
            switch (res) {
                case 0: {
                    return ADDRESSED_SUCCESS;
                }
                case 1: {
                    return ADDRESSED_NO_ACKNOWLEDGE;
                }
                case 2: {
                    return COULD_NOT_BROADCAST;
                }
                case 3: {
                    return BROADCAST_SENT;
                }
                case 4: {
                    return LATE_RECEPTION;
                }
            }
            return null;
        }
    }
}

