/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessage12;
import dk.dma.ais.message.AisMessage6;
import dk.dma.ais.sentence.SendSentence;
import dk.dma.ais.sentence.Sentence;
import dk.dma.ais.sentence.SentenceException;
import dk.dma.ais.sentence.SentenceLine;
import dk.dma.ais.sentence.Vdm;

public class Abm
extends SendSentence {
    private int destination;

    public Abm() {
        this.formatter = "ABM";
        this.channel = Character.valueOf('0');
    }

    public static boolean isAbm(String line) {
        return line.indexOf("!AIABM") >= 0 || line.indexOf("!BSABM") >= 0;
    }

    @Override
    public String getEncoded() {
        super.encode();
        this.encodedFields.add(4, Integer.toString(this.destination));
        return this.finalEncode();
    }

    public int parse(String line) throws SentenceException, SixbitException {
        return this.parse(new SentenceLine(line));
    }

    @Override
    public int parse(SentenceLine sl) throws SentenceException, SixbitException {
        super.baseParse(sl);
        if (!this.formatter.equals("ABM")) {
            throw new SentenceException("Not ABM sentence");
        }
        if (sl.getFields().size() < 9) {
            throw new SentenceException("Sentence does not have at least 9 fields");
        }
        this.destination = Integer.parseInt(sl.getFields().get(4));
        this.channel = sl.getFields().get(5).length() > 0 ? Character.valueOf(sl.getFields().get(5).charAt(0)) : Character.valueOf('\u0000');
        this.msgId = Integer.parseInt(sl.getFields().get(6));
        int padBits = Sentence.parseInt(sl.getFields().get(8));
        this.sixbitString = new StringBuilder(sl.getFields().get(7));
        this.binArray.appendSixbit(sl.getFields().get(7), padBits);
        if (this.completePacket) {
            return 0;
        }
        return 1;
    }

    public int getDestination() {
        return this.destination;
    }

    public void setDestination(int destination) {
        this.destination = destination;
    }

    public AisMessage getAisMessage(int mmsi, int repeat, int retransmit) throws SentenceException, SixbitException {
        AisMessage aisMessage;
        if (this.msgId == 12) {
            AisMessage12 msg12 = new AisMessage12();
            msg12.setDestination(this.getDestination());
            msg12.setUserId(mmsi);
            msg12.setSeqNum(this.getSequence());
            msg12.setRepeat(repeat);
            msg12.setRetransmit(retransmit);
            msg12.setMessage(this.binArray);
            aisMessage = msg12;
        } else if (this.msgId == 6) {
            AisMessage6 msg6 = new AisMessage6();
            msg6.setSeqNum(this.getSequence());
            msg6.setDestination(this.getDestination());
            msg6.setUserId(mmsi);
            msg6.setBinary(this.binArray);
            aisMessage = msg6;
        } else {
            throw new SentenceException("ABM can only contain AIS message 6 or 12");
        }
        return aisMessage;
    }

    public Vdm makeVdm(int mmsi, int repeat, int retransmit) throws SixbitException, SentenceException {
        AisMessage aisMessage = this.getAisMessage(mmsi, repeat, retransmit);
        Vdm vdm = new Vdm();
        vdm.setMsgId(this.getMsgId());
        vdm.setMessageData(aisMessage);
        vdm.setSequence(this.getSequence());
        vdm.setChannel(this.getChannel());
        return vdm;
    }
}

