/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessage14;
import dk.dma.ais.message.AisMessage8;
import dk.dma.ais.sentence.SendSentence;
import dk.dma.ais.sentence.Sentence;
import dk.dma.ais.sentence.SentenceException;
import dk.dma.ais.sentence.SentenceLine;
import dk.dma.ais.sentence.Vdm;

public class Bbm
extends SendSentence {
    public Bbm() {
        this.formatter = "BBM";
        this.channel = Character.valueOf('0');
    }

    public static boolean isBbm(String line) {
        return line.indexOf("!AIBBM") >= 0 || line.indexOf("!BSBBM") >= 0;
    }

    @Override
    public String getEncoded() {
        super.encode();
        return this.finalEncode();
    }

    public int parse(String line) throws SentenceException, SixbitException {
        return this.parse(new SentenceLine(line));
    }

    @Override
    public int parse(SentenceLine sl) throws SentenceException, SixbitException {
        super.baseParse(sl);
        if (!this.formatter.equals("BBM")) {
            throw new SentenceException("Not BBM sentence");
        }
        if (sl.getFields().size() < 9) {
            throw new SentenceException("Sentence does not have at least 8 fields");
        }
        this.msgId = Integer.parseInt(sl.getFields().get(5));
        int padBits = Sentence.parseInt(sl.getFields().get(7));
        this.sixbitString.append(sl.getFields().get(6));
        this.binArray.appendSixbit(sl.getFields().get(6), padBits);
        if (this.completePacket) {
            return 0;
        }
        return 1;
    }

    public AisMessage getAisMessage(int mmsi, int repeat) throws SentenceException, SixbitException {
        AisMessage aisMessage;
        if (this.msgId == 14) {
            AisMessage14 msg14 = new AisMessage14();
            msg14.setUserId(mmsi);
            msg14.setRepeat(repeat);
            msg14.setMessage(this.binArray);
            aisMessage = msg14;
        } else if (this.msgId == 8) {
            AisMessage8 msg8 = new AisMessage8();
            msg8.setRepeat(repeat);
            msg8.setUserId(mmsi);
            msg8.setBinary(this.binArray);
            aisMessage = msg8;
        } else {
            throw new SentenceException("BBM can only contain AIS message 8 or 14");
        }
        return aisMessage;
    }

    public Vdm makeVdm(int mmsi, int repeat) throws SixbitException, SentenceException {
        AisMessage aisMessage = this.getAisMessage(mmsi, repeat);
        Vdm vdm = new Vdm();
        vdm.setMsgId(this.getMsgId());
        vdm.setMessageData(aisMessage);
        vdm.setSequence(this.getSequence());
        vdm.setChannel(this.getChannel());
        return vdm;
    }
}

