/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.sentence.CommentBlockException;
import dk.dma.ais.sentence.CommentBlockLine;
import dk.dma.ais.sentence.Sentence;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public class CommentBlock {
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private int totalLines = -1;
    private int lastLine = -1;
    private String lastGroupId;

    public void addLine(String line) throws CommentBlockException {
        CommentBlockLine cbLine = new CommentBlockLine();
        cbLine.parse(line);
        if (cbLine.getGroupId() != null) {
            if (this.lastGroupId == null) {
                this.lastGroupId = cbLine.getGroupId();
                this.totalLines = cbLine.getTotalLines();
                this.lastLine = cbLine.getLineNumber();
            } else {
                if (cbLine.getTotalLines() != this.totalLines || cbLine.getLineNumber() != this.lastLine + 1 || !cbLine.getGroupId().equals(this.lastGroupId)) {
                    throw new CommentBlockException("Invalid comment block grouping");
                }
                this.lastLine = cbLine.getLineNumber();
            }
            if (this.totalLines == this.lastLine) {
                this.totalLines = -1;
                this.lastLine = -1;
                this.lastGroupId = null;
            }
        } else if (this.lastGroupId != null) {
            throw new CommentBlockException("Single line comment block in unfinished group");
        }
        this.parameterMap.putAll(cbLine.getParameterMap());
    }

    public int getSize() {
        return this.parameterMap.size();
    }

    public String getString(String parameter) {
        return this.parameterMap.get(parameter);
    }

    public void addString(String parameter, String value) {
        this.parameterMap.put(parameter, value);
    }

    public void addInt(String parameter, int value) {
        this.parameterMap.put(parameter, Integer.toString(value));
    }

    public void addTimestamp(Date timestamp) {
        this.parameterMap.put("c", Long.toString(timestamp.getTime() / 1000L));
    }

    public Integer getInt(String parameter) {
        String val = this.parameterMap.get(parameter);
        try {
            return val == null ? null : Integer.valueOf(Integer.parseInt(val));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long getLong(String parameter) {
        String val = this.parameterMap.get(parameter);
        try {
            return val == null ? null : Long.valueOf(Long.parseLong(val));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long getTimestamp() {
        return this.getLong("c");
    }

    public boolean contains(String parameter) {
        return this.parameterMap.containsKey(parameter);
    }

    public static boolean hasCommentBlock(String line) {
        return line.length() > 0 && line.charAt(0) == '\\';
    }

    public boolean isFinished() {
        return this.lastGroupId == null;
    }

    public String getLastGroupId() {
        return this.lastGroupId;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public boolean isEmpty() {
        return this.parameterMap.size() == 0;
    }

    public String encode() {
        return this.encode(80);
    }

    public String encode(int maxLen) {
        ArrayList<String> pairs = new ArrayList<String>();
        for (Map.Entry<String, String> pair : this.parameterMap.entrySet()) {
            if (pair.getKey().equals("g") || pair.getKey().matches("\\d+G\\d+")) continue;
            pairs.add(pair.getKey() + ":" + pair.getValue());
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        int actualMaxLen = maxLen - 5;
        ArrayList<String> currentLine = new ArrayList<String>();
        lines.add(currentLine);
        int currentRemaining = actualMaxLen;
        for (String pair : pairs) {
            if (pair.length() > actualMaxLen) {
                throw new IllegalArgumentException("maxLen to small to accomodate pair: " + pair);
            }
            if (pair.length() > currentRemaining) {
                currentLine = new ArrayList();
                lines.add(currentLine);
                currentLine.add(pair);
                currentRemaining = actualMaxLen - pair.length();
                continue;
            }
            currentLine.add(pair);
            currentRemaining -= pair.length();
        }
        return this.wrapLines(lines);
    }

    private String wrapLines(List<List<String>> lines) {
        ArrayList<String> strLines = new ArrayList<String>();
        for (List<String> line : lines) {
            String lineStr = StringUtils.join(line, (String)",");
            int checksum = 0;
            for (int i = 0; i < lineStr.length(); ++i) {
                checksum ^= lineStr.charAt(i);
            }
            strLines.add("\\" + lineStr + "*" + Sentence.getStringChecksum(checksum) + "\\");
        }
        return StringUtils.join(strLines, (String)"\r\n");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[CommentBlock:");
        for (String parameterCode : this.parameterMap.keySet()) {
            buf.append(" " + parameterCode + ":" + this.parameterMap.get(parameterCode));
        }
        buf.append("]");
        return buf.toString();
    }
}

