/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.sentence.CommentBlockException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommentBlockLine {
    private Map<String, String> parameterMap;
    private Integer totalLines;
    private Integer lineNumber;
    private String groupId;
    private int checksum;

    public void parse(String line) throws CommentBlockException {
        int i;
        this.parameterMap = new HashMap<String, String>();
        int start = -1;
        int end = -1;
        this.checksum = 0;
        for (int i2 = 0; i2 < line.length(); ++i2) {
            char c = line.charAt(i2);
            if (c == '*') {
                end = i2;
                break;
            }
            if (start >= 0) {
                this.checksum ^= c;
            }
            if (c != '\\' || start >= 0) continue;
            start = i2;
        }
        if (start < 0) {
            throw new CommentBlockException("No comment block found");
        }
        if (end < 0) {
            throw new CommentBlockException("Malformed comment block");
        }
        try {
            String given = line.substring(end + 1, end + 3);
            String calculated = Integer.toString(this.checksum, 16).toUpperCase();
            if (this.checksum != Integer.parseInt(given, 16)) {
                throw new CommentBlockException("Wrong checksum " + given + " calculated " + calculated);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new CommentBlockException("Missing checksum in comment block");
        }
        catch (NumberFormatException e) {
            throw new CommentBlockException("Invalid checksum");
        }
        StringBuilder tmpStr = new StringBuilder(16);
        ArrayList<String> fields = new ArrayList<String>();
        for (i = start + 1; i < end; ++i) {
            if (line.charAt(i) == ',' || line.charAt(i) == ':') {
                fields.add(tmpStr.toString());
                tmpStr.setLength(0);
                continue;
            }
            tmpStr.append(line.charAt(i));
        }
        if (start + 1 < end) {
            fields.add(tmpStr.toString());
        }
        if (fields.size() % 2 != 0) {
            throw new CommentBlockException("Malformed comment block");
        }
        for (i = 0; i < fields.size(); i += 2) {
            String parameterCode = (String)fields.get(i);
            String value = (String)fields.get(i + 1);
            int groupCharIndex = parameterCode.indexOf(71);
            if (groupCharIndex >= 0) {
                try {
                    this.lineNumber = Integer.parseInt(parameterCode.substring(0, groupCharIndex));
                    this.totalLines = Integer.parseInt(parameterCode.substring(groupCharIndex + 1, parameterCode.length()));
                }
                catch (NumberFormatException e) {
                    throw new CommentBlockException("Invalid group tag: " + parameterCode);
                }
                this.groupId = value;
            }
            if (parameterCode.equals("g")) {
                String[] tagGroupParts = StringUtils.splitPreserveAllTokens((String)value, (char)'-');
                if (tagGroupParts.length != 3) {
                    throw new CommentBlockException("Invalid TAG block g parameter: " + value);
                }
                try {
                    this.lineNumber = Integer.parseInt(tagGroupParts[0]);
                    this.totalLines = Integer.parseInt(tagGroupParts[1]);
                }
                catch (NumberFormatException e) {
                    throw new CommentBlockException("Invalid TAG block g parameter: " + value);
                }
                this.groupId = tagGroupParts[2];
            }
            this.parameterMap.put(parameterCode, value);
        }
    }

    public Integer getTotalLines() {
        return this.totalLines;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }
}

