/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.sentence.Sentence;
import dk.dma.ais.sentence.SentenceException;
import dk.dma.ais.sentence.SentenceLine;

public abstract class EncapsulatedSentence
extends Sentence {
    protected int msgId;
    protected int total;
    protected Integer sequence;
    private int lastSeq = -1;
    protected int num;
    protected Character channel;
    protected BinArray binArray = new BinArray();
    protected boolean completePacket;
    protected StringBuilder sixbitString = new StringBuilder();
    protected int padBits;

    @Override
    protected void baseParse(SentenceLine sl) throws SentenceException {
        super.baseParse(sl);
        if (sl.getFields().size() < 4) {
            throw new SentenceException("Sentence have less than four fields");
        }
        int thisTotal = Sentence.parseInt(sl.getFields().get(1));
        int thisNum = Sentence.parseInt(sl.getFields().get(2));
        int thisSeq = 0;
        if (sl.getFields().get(3).length() > 0) {
            thisSeq = Sentence.parseInt(sl.getFields().get(3));
        }
        if (this.lastSeq < 0) {
            this.total = thisTotal;
            this.num = thisNum;
            this.sequence = thisSeq;
            this.lastSeq = thisSeq;
            if (this.num != 1 || this.num > this.total) {
                throw new SentenceException("Out of sequence sentence: " + sl.getLine());
            }
        } else {
            if (this.total != thisTotal || thisNum != this.num + 1 || thisSeq != this.lastSeq) {
                throw new SentenceException("Out of sequence sentence: " + sl.getLine());
            }
            this.num = thisNum;
        }
        if (this.num == this.total) {
            this.completePacket = true;
            this.lastSeq = -1;
        }
    }

    @Override
    protected void encode() {
        super.encode();
        this.encodedFields.add(Integer.toString(this.total));
        this.encodedFields.add(Integer.toString(this.num));
        String seq = this.sequence == null ? "" : Integer.toString(this.sequence);
        this.encodedFields.add(seq);
        this.encodedFields.add(this.channel != null ? Character.toString(this.channel.charValue()) : "");
        this.encodedFields.add(this.sixbitString.toString());
        this.encodedFields.add(Integer.toString(this.padBits));
    }

    public int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public Character getChannel() {
        return this.channel;
    }

    public void setChannel(Character channel) {
        this.channel = channel;
    }

    public BinArray getBinArray() {
        return this.binArray;
    }

    public void setBinArray(BinArray binArray) {
        this.binArray = binArray;
    }

    public void setEncodedMessage(SixbitEncoder encoder) throws SixbitException {
        this.sixbitString = new StringBuilder(encoder.encode());
        this.padBits = encoder.getPadBits();
    }

    public void setMessageData(AisMessage aisMessage) throws SixbitException {
        this.msgId = aisMessage.getMsgId();
        SixbitEncoder encoder = aisMessage.getEncoded();
        this.sixbitString = new StringBuilder(encoder.encode());
        this.padBits = encoder.getPadBits();
    }

    public int getPadBits() {
        return this.padBits;
    }

    public boolean isCompletePacket() {
        return this.completePacket;
    }

    public void setSixbitString(String sixbitString) {
        this.sixbitString = new StringBuilder(sixbitString);
    }

    public void setPadBits(int padBits) {
        this.padBits = padBits;
    }

    public String getSixbitString() {
        return this.sixbitString.toString();
    }
}

