/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisBinaryMessage;
import dk.dma.ais.message.AisMessage12;
import dk.dma.ais.message.AisMessage14;
import dk.dma.ais.sentence.Abm;
import dk.dma.ais.sentence.Bbm;
import dk.dma.ais.sentence.EncapsulatedSentence;

public abstract class SendSentence
extends EncapsulatedSentence {
    private static final int DATA_SENTENCE_MAX_LENGTH = 47;

    @Override
    protected void encode() {
        super.encode();
        this.encodedFields.add(5, Integer.toString(this.msgId));
    }

    public void setBinaryData(AisBinaryMessage msg) throws SixbitException {
        this.msgId = msg.getMsgId();
        SixbitEncoder encoder = msg.getBinaryData();
        this.setSixbitString(encoder.encode());
        this.setPadBits(encoder.getPadBits());
    }

    public void setTextData(AisMessage12 msg) throws SixbitException {
        this.msgId = msg.getMsgId();
        this.setText(msg.getMessage());
    }

    public void setTextData(AisMessage14 msg) throws SixbitException {
        this.msgId = msg.getMsgId();
        this.setText(msg.getMessage());
    }

    private void setText(String str) throws SixbitException {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addString(str);
        this.setSixbitString(encoder.encode());
        this.setPadBits(encoder.getPadBits());
    }

    public SendSentence[] split() {
        if (this.sequence == null) {
            this.sequence = 0;
        }
        int sentenceCount = this.sixbitString.length() / 47 + 1;
        SendSentence[] sentences = new SendSentence[sentenceCount];
        for (int i = 0; i < sentenceCount; ++i) {
            SendSentence sendSentence;
            int end;
            int start = i * 47;
            int partPadBits = 0;
            if (i < sentenceCount - 1) {
                end = start + 47;
            } else {
                end = this.sixbitString.length();
                partPadBits = this.padBits;
            }
            String partEncoded = this.sixbitString.substring(start, end);
            if (this instanceof Abm) {
                Abm abm = new Abm();
                abm.setDestination(((Abm)this).getDestination());
                sendSentence = abm;
            } else {
                sendSentence = new Bbm();
            }
            sendSentence.setMsgId(this.msgId);
            sendSentence.setSequence(this.sequence);
            sendSentence.setTotal(sentenceCount);
            sendSentence.setNum(i + 1);
            sendSentence.setSixbitString(partEncoded);
            sendSentence.setPadBits(partPadBits);
            sendSentence.setChannel(this.channel);
            sendSentence.setTalker(this.talker);
            sentences[i] = sendSentence;
        }
        return sentences;
    }
}

