/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.proprietary.IProprietarySourceTag;
import dk.dma.ais.proprietary.IProprietaryTag;
import dk.dma.ais.sentence.CommentBlock;
import dk.dma.ais.sentence.CommentBlockException;
import dk.dma.ais.sentence.SentenceException;
import dk.dma.ais.sentence.SentenceLine;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class Sentence {
    protected String delimiter = "!";
    protected String talker;
    protected String formatter;
    protected int checksum;
    protected String msgChecksum;
    protected String sentenceStr;
    protected List<String> orgLines = new ArrayList<String>();
    protected List<String> rawSentences = new ArrayList<String>();
    protected LinkedList<String> encodedFields;
    protected CommentBlock commentBlock;
    protected LinkedList<IProprietaryTag> tags;
    protected Date mssisTimestamp;

    public abstract int parse(SentenceLine var1) throws SentenceException, SixbitException;

    public abstract String getEncoded();

    protected void baseParse(SentenceLine sl) throws SentenceException {
        this.orgLines.add(sl.getLine());
        this.rawSentences.add(sl.getSentence());
        if (sl.getPrefix().length() > 0 && CommentBlock.hasCommentBlock(sl.getPrefix())) {
            this.addCommentBlock(sl.getPrefix());
        }
        if (!sl.isChecksumMatch()) {
            throw new SentenceException("Invalid checksum for line: " + sl.getLine() + ": " + sl.getChecksumField() + " should have been: " + sl.getChecksumString());
        }
        if (sl.getFields().size() < 2) {
            throw new SentenceException("Invalid sentence, less than two fields");
        }
        if (sl.getTalker() == null || sl.getFormatter() == null) {
            throw new SentenceException("Invalid sentence, wrong talker/formatter: " + sl.getFields().get(0));
        }
        this.mssisTimestamp = Sentence.findMssisTimestamp(sl);
    }

    public void addSingleCommentBlock(String line) throws SentenceException {
        this.orgLines.add(line);
        this.addCommentBlock(line);
    }

    private void addCommentBlock(String line) throws SentenceException {
        if (this.commentBlock == null) {
            this.commentBlock = new CommentBlock();
        }
        try {
            this.commentBlock.addLine(line);
        }
        catch (CommentBlockException e) {
            throw new SentenceException("CommentBlockException: " + e.getMessage());
        }
    }

    protected void encode() {
        this.encodedFields = new LinkedList();
        this.encodedFields.add(this.delimiter + this.talker + this.formatter);
    }

    protected String finalEncode() {
        String encoded;
        this.sentenceStr = encoded = StringUtils.join(this.encodedFields.iterator(), (char)',');
        try {
            this.calculateChecksum();
        }
        catch (SentenceException e) {
            e.printStackTrace();
        }
        this.msgChecksum = Sentence.getStringChecksum(this.checksum);
        encoded = encoded + "*" + this.msgChecksum;
        return encoded;
    }

    private void calculateChecksum() throws SentenceException {
        this.checksum = Sentence.getChecksum(this.sentenceStr);
    }

    public static int getChecksum(String sentence) throws SentenceException {
        int checksum = 0;
        for (int i = 1; i < sentence.length(); ++i) {
            char c = sentence.charAt(i);
            if (c == '!' || c == '$') {
                throw new SentenceException("Start Character Found before Checksum");
            }
            if (c == '*') break;
            checksum ^= c;
        }
        return checksum;
    }

    public static String getStringChecksum(int checksum) {
        String strChecksum = Integer.toString(checksum, 16).toUpperCase();
        if (strChecksum.length() < 2) {
            strChecksum = "0" + strChecksum;
        }
        return strChecksum;
    }

    public static Date findMssisTimestamp(SentenceLine sentenceLine) {
        if (sentenceLine == null) {
            return null;
        }
        int start = sentenceLine.getPostfixStart();
        if (start < 0) {
            return null;
        }
        for (int i = start; i < sentenceLine.getFields().size(); ++i) {
            String field = sentenceLine.getFields().get(i);
            try {
                return new Date(Long.parseLong(field) * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
        }
        return null;
    }

    public Date getMssisTimestamp() {
        return this.mssisTimestamp;
    }

    public Date getTimestamp() {
        Long ts;
        CommentBlock cb = this.getCommentBlock();
        if (cb != null && (ts = cb.getTimestamp()) != null) {
            return new Date(ts * 1000L);
        }
        if (this.getTags() != null) {
            for (IProprietaryTag tag : this.getTags()) {
                Date t;
                if (!(tag instanceof IProprietarySourceTag) || (t = ((IProprietarySourceTag)tag).getTimestamp()) == null) continue;
                return t;
            }
        }
        return this.mssisTimestamp;
    }

    public static int parseInt(String str) throws SentenceException {
        if (str == null || str.length() == 0) {
            throw new SentenceException("Invalid integer field: " + str);
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new SentenceException("Invalid integer field: " + str);
        }
    }

    public static boolean hasSentence(String line) {
        return line.indexOf(33) >= 0 || line.indexOf(36) >= 0;
    }

    public List<String> getOrgLines() {
        return this.orgLines;
    }

    public String getOrgLinesJoined() {
        return StringUtils.join(this.orgLines.iterator(), (String)"\r\n");
    }

    public List<String> getRawSentences() {
        return this.rawSentences;
    }

    public String getRawSentencesJoined() {
        return StringUtils.join(this.rawSentences.iterator(), (String)"\r\n");
    }

    public void setTalker(String talker) {
        this.talker = talker;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public CommentBlock getCommentBlock() {
        return this.commentBlock;
    }

    public LinkedList<IProprietaryTag> getTags() {
        return this.tags;
    }

    public void setTags(LinkedList<IProprietaryTag> tags) {
        this.tags = tags;
    }

    public IProprietarySourceTag getSourceTag() {
        if (this.tags == null) {
            return null;
        }
        Iterator<IProprietaryTag> iterator = this.tags.descendingIterator();
        while (iterator.hasNext()) {
            IProprietaryTag tag = iterator.next();
            if (!(tag instanceof IProprietarySourceTag)) continue;
            return (IProprietarySourceTag)tag;
        }
        return null;
    }

    public void setTag(IProprietaryTag tag) {
        if (this.tags == null) {
            this.tags = new LinkedList();
        }
        this.tags.addFirst(tag);
    }

    public static String convert(String sentence, String talker, String formatter) throws SentenceException {
        String newSentence = sentence.trim();
        newSentence = newSentence.substring(6, newSentence.length() - 3);
        newSentence = "!" + talker + formatter + newSentence;
        String checksum = Integer.toString(Sentence.getChecksum(newSentence), 16).toUpperCase();
        if (checksum.length() < 2) {
            checksum = "0" + checksum;
        }
        newSentence = newSentence + "*" + checksum;
        return newSentence;
    }
}

