/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.proprietary.ProprietaryFactory;
import java.util.Deque;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SentenceException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Deque<String> sentenceTrace;

    public SentenceException() {
        this.sentenceTrace = null;
    }

    public SentenceException(String msg) {
        super(msg);
        this.sentenceTrace = null;
    }

    public SentenceException(String msg, Deque<String> sentenceTrace) {
        super(msg + "\nSentence trace:\n---\n" + StringUtils.join(sentenceTrace, (String)"\n") + "\n---\n");
        this.sentenceTrace = sentenceTrace;
    }

    public SentenceException(SentenceException e, Deque<String> sentenceTrace) {
        this(e.getMessage(), sentenceTrace);
    }

    public String getPossibleProprietaryTag() {
        Optional<String> stringOptional;
        String possibleProprietaryTag = null;
        if (this.sentenceTrace != null && (stringOptional = this.sentenceTrace.stream().filter(line -> ProprietaryFactory.isProprietaryTag(line)).reduce((p, c) -> c)) != null && stringOptional.isPresent()) {
            possibleProprietaryTag = stringOptional.get();
        }
        return possibleProprietaryTag;
    }
}

