/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.proprietary.ProprietaryFactory;
import java.util.ArrayList;
import java.util.List;

public class SentenceLine {
    private static final String[] S1;
    private static final String[] S2;
    private String line;
    private String talker;
    private String formatter;
    private Character delimiter;
    private String prefix;
    private String sentence;
    private ArrayList<String> fields = new ArrayList();
    private int checksum;
    private int checksumField = -1;

    public SentenceLine() {
    }

    public SentenceLine(String line) {
        this.parse(line);
    }

    public void clear() {
        this.line = null;
        this.talker = null;
        this.formatter = null;
        this.delimiter = null;
        this.prefix = null;
        this.sentence = null;
        this.fields.clear();
        this.checksum = 0;
        this.checksumField = -1;
    }

    public void parse(String line) {
        int len;
        this.clear();
        this.line = line;
        int checksumStart = 0;
        int ptr = 0;
        for (len = line.length(); len > 0 && (line.charAt(len - 1) == '\r' || line.charAt(len - 1) == '\n'); --len) {
        }
        while (ptr < len) {
            char ch = line.charAt(ptr);
            if (ch == '!' || ch == '$') {
                this.delimiter = Character.valueOf(ch);
                checksumStart = ptr;
                break;
            }
            ++ptr;
        }
        this.prefix = SentenceLine.convertString(line, 0, ptr);
        if (this.delimiter == null) {
            return;
        }
        int ptrStart = ptr;
        int ps = ptr;
        while (ptr < len) {
            char ch = line.charAt(ptr);
            if (ch == '*') {
                this.fields.add(SentenceLine.convertString(line, ps, ptr));
                this.checksumField = this.fields.size();
                ps = ptr + 1;
            } else if (ch == ',') {
                this.fields.add(SentenceLine.convertString(line, ps, ptr));
                ps = ptr + 1;
            }
            if (ptr > checksumStart && this.checksumField < 0) {
                this.checksum ^= ch;
            }
            ++ptr;
        }
        if (ps < len) {
            this.fields.add(SentenceLine.convertString(line, ps, len));
        }
        if (this.checksumField >= this.fields.size()) {
            this.checksumField = -1;
        }
        this.sentence = SentenceLine.convertString(line, ptrStart, len);
        String f = this.fields.get(0);
        if (f.length() == 6) {
            this.talker = SentenceLine.convertString(f, 1, 3);
            this.formatter = SentenceLine.convertString(f, 3, 6);
        }
    }

    private static String convertString(String f, int start, int end) {
        switch (end - start) {
            case 0: {
                return "";
            }
            case 1: {
                return S1[f.charAt(start)];
            }
            case 2: {
                return S2[(f.charAt(start) << 8) + f.charAt(start + 1)];
            }
        }
        return f.substring(start, end);
    }

    public boolean isFormatter(String ... formatters) {
        if (this.formatter == null) {
            return false;
        }
        for (String f : formatters) {
            if (!this.formatter.equals(f)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSentence() {
        return this.sentence != null;
    }

    public int getPostfixStart() {
        if (this.checksumField < 0) {
            return -1;
        }
        return this.checksumField + 1;
    }

    public boolean isChecksumMatch() {
        String strChecksum = this.getChecksumField();
        if (strChecksum == null) {
            return false;
        }
        try {
            if (Integer.parseInt(strChecksum, 16) != this.checksum) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public String getSentenceHead() {
        return this.delimiter == null || this.fields.size() == 0 ? null : this.fields.get(0);
    }

    public boolean isProprietary() {
        return ProprietaryFactory.isProprietaryTag(this.getSentenceHead());
    }

    public int getChecksum() {
        return this.checksum;
    }

    public String getChecksumString() {
        String strChecksum = Integer.toString(this.checksum, 16).toUpperCase();
        if (strChecksum.length() < 2) {
            strChecksum = "0" + strChecksum;
        }
        return strChecksum;
    }

    public String getChecksumField() {
        return this.checksumField >= 0 ? this.fields.get(this.checksumField) : null;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getTalker() {
        return this.talker;
    }

    public void setTalker(String talker) {
        this.talker = talker;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSentence() {
        return this.sentence;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SentenceLine [line=");
        builder.append(this.line);
        builder.append(", talker=");
        builder.append(this.talker);
        builder.append(", formatter=");
        builder.append(this.formatter);
        builder.append(", delimiter=");
        builder.append(this.delimiter);
        builder.append(", prefix=");
        builder.append(this.prefix);
        builder.append(", sentence=");
        builder.append(this.sentence);
        builder.append(", fields=");
        builder.append(this.fields);
        builder.append("]");
        return builder.toString();
    }

    static {
        int i;
        S1 = new String[256];
        S2 = new String[65536];
        for (i = 0; i < 256; ++i) {
            SentenceLine.S1[i] = Character.toString((char)i);
        }
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                SentenceLine.S2[i * 256 + j] = new String(new char[]{(char)i, (char)j});
            }
        }
    }
}

