/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.sentence;

import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.sentence.EncapsulatedSentence;
import dk.dma.ais.sentence.Sentence;
import dk.dma.ais.sentence.SentenceException;
import dk.dma.ais.sentence.SentenceLine;

public class Vdm
extends EncapsulatedSentence {
    private static final int DATA_SENTENCE_MAX_LENGTH = 61;
    private boolean ownMessage;

    public int parse(String line) throws SentenceException {
        return this.parse(new SentenceLine(line));
    }

    @Override
    public int parse(SentenceLine sl) throws SentenceException {
        super.baseParse(sl);
        if (sl.isFormatter("VDO")) {
            this.ownMessage = true;
        } else if (!sl.isFormatter("VDM")) {
            throw new SentenceException("Not VDM or VDO sentence");
        }
        if (sl.getFields().size() < 8) {
            throw new SentenceException("Sentence does not have at least 8 fields");
        }
        this.channel = sl.getFields().get(4).length() > 0 ? Character.valueOf(sl.getFields().get(4).charAt(0)) : Character.valueOf('\u0000');
        int padBits = Sentence.parseInt(sl.getFields().get(6));
        this.sixbitString.append(sl.getFields().get(5));
        try {
            this.binArray.appendSixbit(sl.getFields().get(5), padBits);
        }
        catch (SixbitException e) {
            throw new SentenceException("Invalid sixbit in VDM: " + e.getMessage() + ": " + sl.getLine());
        }
        if (this.completePacket) {
            try {
                this.msgId = (int)this.binArray.getVal(6);
            }
            catch (SixbitException e) {
                throw new SentenceException("Not enough bits for msgid");
            }
            return 0;
        }
        return 1;
    }

    public static boolean isVdm(String line) {
        int sentenceStart = line.indexOf(33);
        if (sentenceStart < 0) {
            return false;
        }
        int formatterStart = line.indexOf("VDM");
        if (formatterStart < 0) {
            formatterStart = line.indexOf("VDO");
        }
        return formatterStart == sentenceStart + 3;
    }

    public boolean isOwnMessage() {
        return this.ownMessage;
    }

    @Override
    public String getEncoded() {
        this.formatter = this.isOwnMessage() ? "VDO" : "VDM";
        super.encode();
        return this.finalEncode();
    }

    public static String[] createSentences(AisMessage aisMessage, int sequence) throws SixbitException {
        SixbitEncoder encoder = aisMessage.getEncoded();
        String encoded = encoder.encode();
        int padBits = encoder.getPadBits();
        int sentenceCount = encoded.length() / 61 + 1;
        String[] sentences = new String[sentenceCount];
        for (int i = 0; i < sentenceCount; ++i) {
            int end;
            int start = i * 61;
            int partPadBits = 0;
            if (i < sentenceCount - 1) {
                end = start + 61;
            } else {
                end = encoded.length();
                partPadBits = padBits;
            }
            String partEncoded = encoded.substring(start, end);
            Vdm vdm = new Vdm();
            vdm.setMsgId(aisMessage.getMsgId());
            vdm.setTalker("AI");
            vdm.setTotal(sentenceCount);
            vdm.setNum(i + 1);
            vdm.setSequence(sequence);
            vdm.setSixbitString(partEncoded);
            vdm.setPadBits(partPadBits);
            sentences[i] = vdm.getEncoded();
        }
        return sentences;
    }

    public Vdm[] createSentences() {
        if (this.sequence == null) {
            this.sequence = 0;
        }
        int sentenceCount = this.sixbitString.length() / 61 + 1;
        Vdm[] sentences = new Vdm[sentenceCount];
        for (int i = 0; i < sentenceCount; ++i) {
            int end;
            int start = i * 61;
            int partPadBits = 0;
            if (i < sentenceCount - 1) {
                end = start + 61;
            } else {
                end = this.sixbitString.length();
                partPadBits = this.padBits;
            }
            String partEncoded = this.sixbitString.substring(start, end);
            Vdm vdm = new Vdm();
            vdm.setMsgId(this.msgId);
            vdm.setTalker("AI");
            vdm.setTotal(sentenceCount);
            vdm.setNum(i + 1);
            vdm.setSequence(this.sequence);
            vdm.setSixbitString(partEncoded);
            vdm.setPadBits(partPadBits);
            vdm.setChannel(this.channel);
            sentences[i] = vdm;
        }
        return sentences;
    }
}

