/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import edu.hm.hafner.ArchitectureRulesTest;
import javax.xml.parsers.SAXParser;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.binder.DigesterLoader;
import org.junit.jupiter.api.Test;
import org.xml.sax.XMLReader;

public class ArchitectureRulesTest {
    private static final DescribedPredicate<JavaCall<?>> ACCESS_IS_RESTRICTED_TO_TESTS = new AccessRestrictedToTests();

    protected JavaClasses getAllClasses() {
        return new ClassFileImporter().importPackages(new String[]{"edu.hm.hafner"});
    }

    @Test
    void shouldNotCreateDigesterWithConstructor() {
        JavaClasses classes = this.getAllClasses();
        ClassesShouldConjunction noDigesterConstructorCalled = ((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().dontHaveSimpleName("SecureDigester")).should().callConstructor(Digester.class, new Class[0]).orShould().callConstructor(Digester.class, new Class[]{SAXParser.class}).orShould().callConstructor(Digester.class, new Class[]{XMLReader.class}).orShould().callMethod(DigesterLoader.class, "newDigester", new Class[0]);
        noDigesterConstructorCalled.check(classes);
    }

    @Test
    void shouldNotUsePublicInTestCases() {
        JavaClasses classes = this.getAllClasses();
        ClassesShouldConjunction noPublicClasses = ((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().dontHaveModifier(JavaModifier.ABSTRACT)).and().haveSimpleNameEndingWith("Test")).and().haveNameNotMatching(this.getClass().getName())).and(DescribedPredicate.dont(this.areAllowedPublicTestClasses())).should().bePublic();
        noPublicClasses.check(classes);
    }

    protected DescribedPredicate<? super JavaClass> areAllowedPublicTestClasses() {
        return ArchPredicates.have((DescribedPredicate)JavaClass.Predicates.simpleName((String)"IssueTest")).or(JavaClass.Predicates.simpleName((String)"EclipseParserTest")).or(JavaClass.Predicates.simpleName((String)"Pep8ParserTest"));
    }

    @Test
    void shouldNotCallVisibleForTestingOutsideOfTest() {
        JavaClasses classes = this.getAllClasses();
        ClassesShouldConjunction noTestApiCalled = ((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().haveSimpleNameNotEndingWith("Test")).should().callCodeUnitWhere(ACCESS_IS_RESTRICTED_TO_TESTS);
        noTestApiCalled.check(classes);
    }

    @Test
    void shouldNotUseForbiddenModules() {
        JavaClasses classes = this.getAllClasses();
        ArchRule restrictedApi = (ArchRule)ArchRuleDefinition.noClasses().should().accessClassesThat().resideInAnyPackage(this.getForbiddenPackages());
        restrictedApi.check(classes);
    }

    protected String[] getForbiddenPackages() {
        return new String[]{"org.apache.commons.lang..", "javax.xml.bind.."};
    }
}

