/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.assertj.Assertions;
import edu.hm.hafner.analysis.assertj.SoftAssertions;
import edu.hm.hafner.util.SerializableTest;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import org.assertj.core.api.StringAssert;
import org.junit.jupiter.api.Test;

public class IssueTest
extends SerializableTest<Issue> {
    private static final String SERIALIZATION_NAME = "issue.ser";
    static final String FILE_NAME = "C:/users/tester/file-name";
    static final String FILE_NAME_WITH_BACKSLASHES = "C:\\users\\tester/file-name";
    static final int LINE_START = 1;
    static final int LINE_END = 2;
    static final int COLUMN_START = 3;
    static final int COLUMN_END = 4;
    static final String CATEGORY = "category";
    static final String TYPE = "type";
    static final String PACKAGE_NAME = "package-name";
    static final String MODULE_NAME = "module-name";
    static final Severity SEVERITY = Severity.WARNING_HIGH;
    static final String MESSAGE = "message";
    static final String MESSAGE_NOT_STRIPPED = "    message  ";
    static final String DESCRIPTION = "description";
    static final String DESCRIPTION_NOT_STRIPPED = "    description  ";
    static final String EMPTY = "";
    static final String UNDEFINED = "-";
    static final String FINGERPRINT = "fingerprint";
    static final String ORIGIN = "origin";
    static final String REFERENCE = "reference";
    static final String ADDITIONAL_PROPERTIES = "additional";
    static final LineRangeList LINE_RANGES = new LineRangeList(Collections.singletonList(new LineRange(5, 6)));

    protected Issue createIssue(@CheckForNull String fileName, int lineStart, int lineEnd, int columnStart, int columnEnd, @CheckForNull String category, @CheckForNull String type, @CheckForNull String packageName, @CheckForNull String moduleName, @CheckForNull Severity priority, @CheckForNull String message, @CheckForNull String description, @CheckForNull String origin, @CheckForNull String reference, @CheckForNull String fingerprint, String additionalProperties) {
        return new Issue(fileName, lineStart, lineEnd, columnStart, columnEnd, LINE_RANGES, category, type, packageName, moduleName, priority, message, description, origin, reference, fingerprint, (Serializable)((Object)additionalProperties), UUID.randomUUID());
    }

    @Test
    void shouldEnsureThatEndIsGreaterOrEqualStart() {
        Issue issue = new Issue(FILE_NAME, 2, 1, 2, 1, LINE_RANGES, CATEGORY, TYPE, PACKAGE_NAME, MODULE_NAME, SEVERITY, MESSAGE, DESCRIPTION, ORIGIN, REFERENCE, FINGERPRINT, (Serializable)((Object)ADDITIONAL_PROPERTIES), UUID.randomUUID());
        Assertions.assertThat(issue).hasLineStart(1).hasLineEnd(2);
        Assertions.assertThat(issue).hasColumnStart(1).hasColumnEnd(2);
    }

    @Test
    void shouldSetAllPropertiesInConstructor() {
        Issue issue = this.createFilledIssue();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(issue.getId()).isNotNull();
            softly.assertThat(issue).hasFileName(FILE_NAME).hasCategory(CATEGORY).hasLineStart(1).hasLineEnd(2).hasColumnStart(3).hasColumnEnd(4).hasType(TYPE).hasPackageName(PACKAGE_NAME).hasModuleName(MODULE_NAME).hasSeverity(SEVERITY).hasMessage(MESSAGE).hasOrigin(ORIGIN).hasDescription(DESCRIPTION).hasFingerprint(FINGERPRINT);
            softly.assertThat(issue.hasFingerprint()).isTrue();
            softly.assertThat(issue.hasPackageName()).isTrue();
            softly.assertThat(issue.hasModuleName()).isTrue();
        });
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(Issue.getPropertyValueAsString((Issue)issue, (String)"fileName")).isEqualTo((Object)issue.getFileName());
            softly.assertThat(Issue.getPropertyValueAsString((Issue)issue, (String)CATEGORY)).isEqualTo((Object)issue.getCategory());
            softly.assertThat(Issue.getPropertyValueAsString((Issue)issue, (String)"lineStart")).isEqualTo((Object)String.valueOf(issue.getLineStart()));
            softly.assertThat(Issue.getPropertyValueAsString((Issue)issue, (String)"severity")).isEqualTo((Object)issue.getSeverity().toString());
        });
    }

    @Test
    void shouldChangeMutableProperties() {
        Issue issue = this.createFilledIssue();
        String origin = "new-origin";
        issue.setOrigin(origin);
        String reference = "new-reference";
        issue.setReference(reference);
        String moduleName = "new-module";
        issue.setModuleName(moduleName);
        String packageName = "new-package";
        issue.setPackageName(packageName);
        String fileName = "new-file";
        issue.setFileName(fileName);
        String fingerprint = "new-fingerprint";
        issue.setFingerprint(fingerprint);
        SoftAssertions.assertSoftly(softly -> softly.assertThat(issue).hasOrigin(origin).hasReference(reference).hasModuleName(moduleName).hasPackageName(packageName).hasFileName(fileName).hasFingerprint(fingerprint));
    }

    @Test
    void testDefaultIssueNullStringsNegativeIntegers() {
        Issue issue = this.createIssue(null, 0, 0, 0, 0, null, null, null, null, SEVERITY, null, null, null, null, null, null);
        this.assertIsDefaultIssue(issue);
    }

    @Test
    void testDefaultIssueEmptyStringsNegativeIntegers() {
        Issue issue = this.createIssue(EMPTY, -1, -1, -1, -1, EMPTY, EMPTY, EMPTY, EMPTY, SEVERITY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.assertIsDefaultIssue(issue);
    }

    private void assertIsDefaultIssue(Issue issue) {
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(issue.getId()).isNotNull();
            softly.assertThat(issue).hasFileName(UNDEFINED).hasCategory(EMPTY).hasLineStart(0).hasLineEnd(0).hasColumnStart(0).hasColumnEnd(0).hasType(UNDEFINED).hasPackageName(UNDEFINED).hasMessage(EMPTY).hasDescription(EMPTY).hasFingerprint(UNDEFINED);
            softly.assertThat(issue.hasFingerprint()).isFalse();
            softly.assertThat(issue.hasPackageName()).isFalse();
            softly.assertThat(issue.hasModuleName()).isFalse();
        });
    }

    @Test
    void testZeroLineColumnEndsDefaultToLineColumnStarts() {
        Issue issue = this.createIssue(FILE_NAME, 1, 0, 3, 0, CATEGORY, TYPE, PACKAGE_NAME, MODULE_NAME, SEVERITY, MESSAGE, DESCRIPTION, ORIGIN, REFERENCE, FINGERPRINT, ADDITIONAL_PROPERTIES);
        SoftAssertions.assertSoftly(softly -> softly.assertThat(issue).hasLineStart(1).hasLineEnd(1).hasColumnStart(3).hasColumnEnd(3));
    }

    @Test
    void testNullPriorityDefaultsToNormal() {
        Issue issue = this.createIssue(FILE_NAME, 1, 2, 3, 4, CATEGORY, TYPE, PACKAGE_NAME, MODULE_NAME, null, MESSAGE, DESCRIPTION, ORIGIN, REFERENCE, FINGERPRINT, ADDITIONAL_PROPERTIES);
        Assertions.assertThat((Object)issue.getSeverity()).isEqualTo((Object)Severity.WARNING_NORMAL);
    }

    @Test
    void testIdRandomlyGenerated() {
        Issue one = this.createFilledIssue();
        Issue another = this.createFilledIssue();
        Assertions.assertThat((Comparable)one.getId()).isNotEqualTo((Object)another.getId());
    }

    protected Issue createFilledIssue() {
        return this.createIssue(FILE_NAME, 1, 2, 3, 4, CATEGORY, TYPE, PACKAGE_NAME, MODULE_NAME, SEVERITY, MESSAGE, DESCRIPTION, ORIGIN, REFERENCE, FINGERPRINT, ADDITIONAL_PROPERTIES);
    }

    @Test
    void testToString() {
        Issue issue = this.createFilledIssue();
        SoftAssertions.assertSoftly(softly -> ((StringAssert)((StringAssert)((StringAssert)((StringAssert)((StringAssert)softly.assertThat(issue.toString()).contains(new CharSequence[]{FILE_NAME})).contains(new CharSequence[]{Integer.toString(1)})).contains(new CharSequence[]{Integer.toString(3)})).contains(new CharSequence[]{CATEGORY})).contains(new CharSequence[]{TYPE})).contains(new CharSequence[]{MESSAGE}));
    }

    @Test
    void testFileNameBackslashConversion() {
        Issue issue = this.createIssue(FILE_NAME_WITH_BACKSLASHES, 1, 2, 3, 4, CATEGORY, TYPE, PACKAGE_NAME, MODULE_NAME, SEVERITY, MESSAGE, DESCRIPTION, ORIGIN, REFERENCE, FINGERPRINT, ADDITIONAL_PROPERTIES);
        Assertions.assertThat(issue).hasFileName(FILE_NAME);
    }

    @Test
    void testMessageDescriptionStripped() {
        Issue issue = this.createIssue(FILE_NAME_WITH_BACKSLASHES, 1, 2, 3, 4, CATEGORY, TYPE, PACKAGE_NAME, MODULE_NAME, SEVERITY, MESSAGE_NOT_STRIPPED, DESCRIPTION_NOT_STRIPPED, ORIGIN, REFERENCE, FINGERPRINT, ADDITIONAL_PROPERTIES);
        SoftAssertions.assertSoftly(softly -> softly.assertThat(issue).hasMessage(MESSAGE).hasDescription(DESCRIPTION));
    }

    @Override
    protected Issue createSerializable() {
        return this.createFilledIssue();
    }

    @Test
    void shouldReadIssueFromOldSerialization() {
        byte[] restored = this.readAllBytes(SERIALIZATION_NAME);
        this.assertThatSerializableCanBeRestoredFrom(restored);
    }

    public static void main(String ... args) throws IOException {
        new IssueTest().createSerializationFile();
    }
}

