/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.assertj;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Severity;
import java.util.Objects;
import java.util.UUID;
import org.assertj.core.api.AbstractAssert;

public class IssueAssert
extends AbstractAssert<IssueAssert, Issue> {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%nExpecting %s of:%n <%s>%nto be:%n <%s>%nbut was:%n <%s>.";

    public IssueAssert(Issue actual) {
        super((Object)actual, IssueAssert.class);
    }

    public static IssueAssert assertThat(Issue actual) {
        return new IssueAssert(actual);
    }

    public IssueAssert hasId(UUID id) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getId(), id)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"id", this.actual, id, ((Issue)this.actual).getId()});
        }
        return this;
    }

    public IssueAssert hasBaseName(String baseName) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getBaseName(), baseName)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"base name", this.actual, baseName, ((Issue)this.actual).getBaseName()});
        }
        return this;
    }

    public IssueAssert hasFileName(String fileName) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getFileName(), fileName)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"file name", this.actual, fileName, ((Issue)this.actual).getFileName()});
        }
        return this;
    }

    public IssueAssert hasCategory(String category) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getCategory(), category)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"category", this.actual, category, ((Issue)this.actual).getCategory()});
        }
        return this;
    }

    public IssueAssert hasType(String type) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getType(), type)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"type", this.actual, type, ((Issue)this.actual).getType()});
        }
        return this;
    }

    public IssueAssert hasSeverity(Severity severity) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getSeverity(), severity)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"severity", this.actual, severity, ((Issue)this.actual).getSeverity()});
        }
        return this;
    }

    public IssueAssert hasMessage(String message) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getMessage(), message)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"message", this.actual, message, ((Issue)this.actual).getMessage()});
        }
        return this;
    }

    public IssueAssert hasDescription(String description) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getDescription(), description)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"description", this.actual, description, ((Issue)this.actual).getDescription()});
        }
        return this;
    }

    public IssueAssert hasModuleName(String moduleName) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getModuleName(), moduleName)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"moduleName", this.actual, moduleName, ((Issue)this.actual).getModuleName()});
        }
        return this;
    }

    public IssueAssert hasOrigin(String origin) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getOrigin(), origin)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"origin", this.actual, origin, ((Issue)this.actual).getOrigin()});
        }
        return this;
    }

    public IssueAssert hasLineStart(int lineStart) {
        this.isNotNull();
        if (((Issue)this.actual).getLineStart() != lineStart) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"line start", this.actual, lineStart, ((Issue)this.actual).getLineStart()});
        }
        return this;
    }

    public IssueAssert hasLineEnd(int lineEnd) {
        this.isNotNull();
        if (((Issue)this.actual).getLineEnd() != lineEnd) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"line end", this.actual, lineEnd, ((Issue)this.actual).getLineEnd()});
        }
        return this;
    }

    public IssueAssert hasColumnStart(int columnStart) {
        this.isNotNull();
        if (((Issue)this.actual).getColumnStart() != columnStart) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"column start", this.actual, columnStart, ((Issue)this.actual).getColumnStart()});
        }
        return this;
    }

    public IssueAssert hasColumnEnd(int columnEnd) {
        this.isNotNull();
        if (((Issue)this.actual).getColumnEnd() != columnEnd) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"column end", this.actual, columnEnd, ((Issue)this.actual).getColumnEnd()});
        }
        return this;
    }

    public IssueAssert hasPackageName(String packageName) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getPackageName(), packageName)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"package name", this.actual, packageName, ((Issue)this.actual).getPackageName()});
        }
        return this;
    }

    public IssueAssert hasFingerprint(String fingerprint) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getFingerprint(), fingerprint)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"fingerprint", this.actual, fingerprint, ((Issue)this.actual).getFingerprint()});
        }
        return this;
    }

    public IssueAssert hasReference(String reference) {
        this.isNotNull();
        if (!Objects.equals(((Issue)this.actual).getReference(), reference)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"reference", this.actual, reference, ((Issue)this.actual).getReference()});
        }
        return this;
    }
}

