/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.PackageDetectors;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.util.stream.Stream;
import org.apache.commons.io.input.BOMInputStream;

public abstract class AbstractPackageDetector {
    private final PackageDetectors.FileSystem fileSystem;

    protected AbstractPackageDetector(PackageDetectors.FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String detectPackageName(String fileName, Charset charset) {
        if (this.accepts(fileName)) {
            String string;
            block9: {
                InputStream stream = this.fileSystem.openFile(fileName);
                Throwable throwable = null;
                try {
                    string = this.detectPackageName(stream, charset);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (stream != null) {
                                AbstractPackageDetector.$closeResource(throwable, stream);
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException | InvalidPathException exception) {
                        // empty catch block
                    }
                }
                AbstractPackageDetector.$closeResource(throwable, stream);
            }
            return string;
        }
        return "-";
    }

    @VisibleForTesting
    String detectPackageName(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(stream), charset));){
            String string = this.detectPackageName(buffer.lines());
            return string;
        }
    }

    abstract boolean accepts(String var1);

    abstract String detectPackageName(Stream<String> var1);
}

