/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.PackageDetectors;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PackageNameResolver {
    private final PackageDetectors packageDetectors;

    public PackageNameResolver() {
        this(new PackageDetectors.FileSystem());
    }

    @VisibleForTesting
    PackageNameResolver(PackageDetectors.FileSystem fileSystem) {
        this.packageDetectors = new PackageDetectors(fileSystem);
    }

    public void run(Report report, Charset charset) {
        Set filesWithoutPackageName = report.stream().filter(issue -> !issue.hasPackageName()).map(Issue::getFileName).collect(Collectors.toSet());
        if (filesWithoutPackageName.isEmpty()) {
            report.logInfo("-> all affected files already have a valid package name", new Object[0]);
            return;
        }
        Map packagesOfFiles = filesWithoutPackageName.stream().collect(Collectors.toMap(Function.identity(), this.findPackage(charset)));
        report.stream().forEach(issue -> {
            if (!issue.hasPackageName()) {
                issue.setPackageName((String)packagesOfFiles.get(issue.getFileName()));
            }
        });
        report.logInfo("-> resolved package names of %d affected files", filesWithoutPackageName.size());
    }

    private Function<String, String> findPackage(Charset charset) {
        return fileName -> this.packageDetectors.detectPackageName((String)fileName, charset);
    }
}

