/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.RegexpParser;
import edu.hm.hafner.analysis.Report;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public abstract class RegexpLineParser
extends RegexpParser {
    private static final long serialVersionUID = 5932670979793111138L;
    private int currentLine = 0;

    protected RegexpLineParser(String warningPattern) {
        super(warningPattern, false);
    }

    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        Report report = new Report();
        try (LineIterator iterator = IOUtils.lineIterator((Reader)reader);){
            this.currentLine = 1;
            while (iterator.hasNext()) {
                String line = preProcessor.apply(iterator.nextLine());
                this.findIssues(line, report);
                ++this.currentLine;
            }
        }
        catch (IOException exception) {
            throw new ParsingException(exception, "Can't read input lines");
        }
        return this.postProcess(report);
    }

    protected Report postProcess(Report report) {
        return report;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }
}

