/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class Armcc5CompilerParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = -2677728927938443701L;
    private static final String ARMCC5_WARNING_PATTERN = "^(.+)\\((\\d+)\\): (warning|error):  #(.+): (.+)$";

    public Armcc5CompilerParser() {
        super(ARMCC5_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("#");
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String fileName = matcher.group(1);
        int lineNumber = this.parseInt(matcher.group(2));
        String type = matcher.group(3);
        String errorCode = matcher.group(4);
        String message = matcher.group(5);
        Severity priority = "error".equalsIgnoreCase(type) ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
        return builder.setFileName(fileName).setLineStart(lineNumber).setMessage(errorCode + " - " + message).setSeverity(priority).build();
    }
}

