/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpDocumentParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DrMemoryParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 7195239138601238590L;
    private static final String DR_MEMORY_WARNING_PATTERN = "(?:Error #\\d+: ([\\s\\S]+?)\\r?\\n(# \\d+ [\\s\\S]*?\\r?\\n)(?=[^#])(Note: [\\s\\S]*?\\r?\\n\\r?\\n)?|Error #\\d+: ([\\s\\S]+?)\\r?\\n\\r?\\n)";
    private static final int FIRST_HEADER_GROUP = 1;
    private static final int STACK_TRACE_GROUP = 2;
    private static final int NOTES_GROUP = 3;
    private static final int SECOND_HEADER_GROUP = 4;
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("#\\s*\\d+.*?\\[(.*\\/?.*):(\\d+)\\]");
    private static final int FILE_PATH_GROUP = 1;
    private static final int LINE_NUMBER_GROUP = 2;
    private static final Pattern JENKINS_PATH_PATTERN = Pattern.compile(".*?(\\/jobs\\/.*?\\/workspace\\/|workspace\\/)");

    public DrMemoryParser() {
        super(DR_MEMORY_WARNING_PATTERN, false);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String tempHeader;
        StringBuilder messageBuilder = new StringBuilder();
        String filePath = "Nil";
        int lineNumber = 0;
        String header = "";
        if (matcher.group(4) == null) {
            String notes;
            String stackTrace;
            tempHeader = matcher.group(1);
            if (tempHeader != null) {
                header = tempHeader.trim();
                messageBuilder.append(header);
            }
            if ((stackTrace = matcher.group(2)) != null) {
                SourceCodeLocation location = this.findOriginatingErrLocation(stackTrace.trim().split("\\r?\\n"));
                filePath = location.getFilePath();
                lineNumber = location.getLineNumber();
                stackTrace = stackTrace.trim();
                messageBuilder.append("\n");
                messageBuilder.append(stackTrace);
            }
            if ((notes = matcher.group(3)) != null) {
                notes = notes.trim();
                messageBuilder.append("\n");
                messageBuilder.append(notes);
            }
        } else {
            tempHeader = matcher.group(4);
            if (tempHeader != null) {
                header = tempHeader.trim();
                messageBuilder.append(header);
            }
        }
        String message = messageBuilder.length() == 0 ? "Unknown Dr. Memory Error" : messageBuilder.toString().replace("\n", "<br>");
        header = header.toLowerCase(Locale.ENGLISH);
        String category = "Unknown";
        Severity priority = Severity.WARNING_HIGH;
        if (StringUtils.isNotBlank((CharSequence)header)) {
            if (header.startsWith("unaddressable access")) {
                category = "Unaddressable Access";
            } else if (header.startsWith("uninitialized read")) {
                category = "Uninitialized Read";
            } else if (header.startsWith("invalid heap argument")) {
                category = "Invalid Heap Argument";
            } else if (header.startsWith("possible leak")) {
                category = "Possible Leak";
                priority = Severity.WARNING_NORMAL;
            } else if (header.startsWith("reachable leak")) {
                category = "Reachable Leak";
            } else if (header.startsWith("leak")) {
                category = "Leak";
            } else if (header.startsWith("gdi usage error")) {
                category = "GDI Usage Error";
                priority = Severity.WARNING_NORMAL;
            } else if (header.startsWith("handle leak")) {
                category = "Handle Leak";
                priority = Severity.WARNING_NORMAL;
            } else if (header.startsWith("warning")) {
                category = "Warning";
                priority = Severity.WARNING_NORMAL;
            }
        }
        return builder.setFileName(filePath).setLineStart(lineNumber).setCategory(category).setMessage(message).setSeverity(priority).build();
    }

    private SourceCodeLocation findOriginatingErrLocation(String[] stackTrace) {
        String errFilePath = "Unknown";
        int lineNumber = 0;
        for (String line : stackTrace) {
            Matcher pathMatcher = FILE_PATH_PATTERN.matcher(line);
            if (!pathMatcher.find()) continue;
            errFilePath = pathMatcher.group(1);
            lineNumber = this.parseInt(pathMatcher.group(2));
            Matcher jenkinsPathMatcher = JENKINS_PATH_PATTERN.matcher(errFilePath);
            if (!jenkinsPathMatcher.find()) continue;
            return new SourceCodeLocation(errFilePath, lineNumber);
        }
        return new SourceCodeLocation(errFilePath, lineNumber);
    }

    private static final class SourceCodeLocation {
        private final String filePath;
        private final int lineNumber;

        SourceCodeLocation(String filePath, int lineNumber) {
            this.filePath = filePath;
            this.lineNumber = lineNumber;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

