/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpDocumentParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class GhsMultiParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 8149238560432255036L;
    private static final String GHS_MULTI_WARNING_PATTERN = "(?:\\.|[A-Z]:)(.*)\"\\,\\s*line\\s*(\\d+):\\s*(warning|error)\\s*([^:]+):\\s*(?m)([^\\^]*)\\s*\\^";

    public GhsMultiParser() {
        super(GHS_MULTI_WARNING_PATTERN, true);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String type = StringUtils.capitalize((String)matcher.group(3));
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setCategory(matcher.group(4)).setMessage(matcher.group(5)).setSeverity(this.mapPriority(type)).build();
    }

    private Severity mapPriority(String type) {
        Severity priority = "warning".equalsIgnoreCase(type) ? Severity.WARNING_NORMAL : Severity.WARNING_HIGH;
        return priority;
    }
}

