/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.VisibleForTesting;
import java.util.Locale;
import java.util.regex.Matcher;

public class GnuMakeGccParser
extends RegexpLineParser {
    private static final long serialVersionUID = -67701741403245309L;
    private static final String SLASH = "/";
    private static final String ERROR = "error";
    private static final String GNUMAKEGCC_WARNING_PATTERN = "^((?:.*\\[.*\\])?\\s*(.*\\.[chpimxsola0-9]+):(\\d+):(?:\\d+:)? (warning|error): (.*)$)|((^g?make(\\[.*\\])?: Entering directory)\\s*(['`]((.*))\\'))";
    private String directory = "";
    private final boolean isWindows;

    public GnuMakeGccParser() {
        this(System.getProperty("os.name"));
    }

    @VisibleForTesting
    GnuMakeGccParser(String os) {
        super(GNUMAKEGCC_WARNING_PATTERN);
        this.isWindows = os.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        if (matcher.group(1) == null) {
            return this.handleDirectory(matcher);
        }
        return this.handleWarning(matcher, builder);
    }

    private Issue handleWarning(Matcher matcher, IssueBuilder builder) {
        String category;
        Severity priority;
        String fileName = matcher.group(2);
        if (fileName.startsWith(SLASH)) {
            builder.setFileName(fileName);
        } else {
            builder.setFileName(this.directory + fileName);
        }
        if (ERROR.equalsIgnoreCase(matcher.group(4))) {
            priority = Severity.WARNING_HIGH;
            category = "Error";
        } else {
            priority = Severity.WARNING_NORMAL;
            category = "Warning";
        }
        return builder.setLineStart(this.parseInt(matcher.group(3))).setCategory(category).setMessage(matcher.group(5)).setSeverity(priority).build();
    }

    private String fixMsysTypeDirectory(String path) {
        if (this.isWindows && path.matches("/[a-z]/.*")) {
            return path.substring(1, 2) + ":" + path.substring(2);
        }
        return path;
    }

    private Issue handleDirectory(Matcher matcher) {
        this.directory = matcher.group(10) + SLASH;
        this.directory = this.fixMsysTypeDirectory(this.directory);
        return FALSE_POSITIVE;
    }
}

