/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.JSLintXmlSaxParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LintParser
extends AbstractParser {
    private static final long serialVersionUID = 3341424685245834156L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader file, Function<String, String> preProcessor) throws ParsingException, ParsingCanceledException {
        try (ReaderInputStream inputStream = new ReaderInputStream(file, StandardCharsets.UTF_8);){
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            Report report = new Report();
            parser.parse((InputStream)inputStream, (DefaultHandler)new JSLintXmlSaxParser(report));
            Report report2 = report;
            return report2;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParsingException(e);
        }
    }
}

