/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.RegexpParser;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxKernelOutputParser
extends RegexpParser {
    private static final long serialVersionUID = 7580943036264863780L;
    private static final String PREAMBLE = "(?s)";
    private static final String KERN_TIMESTAMP = "\\[[ ]*[0-9]+\\.[0-9]+\\]";
    private static final String BUGWARN_START = " ------------\\[ cut here \\]------------";
    private static final String BUGWARN_END = " ---\\[ end trace [0-9a-fA-F]+ \\]---";
    private static final String BUGWARN = "(\\[[ ]*[0-9]+\\.[0-9]+\\]) ------------\\[ cut here \\]------------(.*?)\\[[ ]*[0-9]+\\.[0-9]+\\]( ---\\[ end trace [0-9a-fA-F]+ \\]---)";
    private static final String KERNOUTPUT = "(\\[[ ]*[0-9]+\\.[0-9]+\\])([^\n]*)";
    private static final String LINUX_KERNEL_OUTPUT_WARNING_PATTERN = "(?s)((\\[[ ]*[0-9]+\\.[0-9]+\\]) ------------\\[ cut here \\]------------(.*?)\\[[ ]*[0-9]+\\.[0-9]+\\]( ---\\[ end trace [0-9a-fA-F]+ \\]---)|(\\[[ ]*[0-9]+\\.[0-9]+\\])([^\n]*))";
    private static final String KERNOUTPUT_PATERN = "(?s)(\\[[ ]*[0-9]+\\.[0-9]+\\])([^\n]*)";
    private static final String BUGWARN_START_PATERN = "(?s)\\[[ ]*[0-9]+\\.[0-9]+\\] ------------\\[ cut here \\]------------";
    private static final String BUGWARN_END_PATERN = "(?s)\\[[ ]*[0-9]+\\.[0-9]+\\] ---\\[ end trace [0-9a-fA-F]+ \\]---";
    private static final int BUGWARN_CONTENT = 3;
    private static final int BUGWARN_ENDTRACE = 4;
    private static final int KERNOUTPUT_CONTENT = 6;
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("(BUG|WARNING)[^/]*at[ ](((?:[^/]*/)*.*):(\\d+))?([^+!]*)");
    private static final int ERROR_TYPE = 1;
    private static final int ERROR_PATH = 3;
    private static final int ERROR_LINE = 4;
    private static final int ERROR_FUNC = 5;
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\[[ ]*[0-9]+\\.[0-9]+\\]");

    public LinuxKernelOutputParser() {
        super(LINUX_KERNEL_OUTPUT_WARNING_PATTERN, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(Reader file, Function<String, String> preProcessor) throws ParsingException, ParsingCanceledException {
        try (BufferedReader reader = new BufferedReader(file);){
            Report warnings = new Report();
            String line = reader.readLine();
            Pattern pBugStart = Pattern.compile(BUGWARN_START_PATERN);
            Pattern pBugEnd = Pattern.compile(BUGWARN_END_PATERN);
            Pattern pOutput = Pattern.compile(KERNOUTPUT_PATERN);
            while (line != null) {
                Matcher m = pBugStart.matcher(line);
                if (m.matches()) {
                    StringBuilder buf = new StringBuilder();
                    do {
                        buf.append(preProcessor.apply(line)).append('\n');
                    } while (!(m = pBugEnd.matcher(line = reader.readLine())).matches());
                    buf.append(preProcessor.apply(line)).append('\n');
                    this.findIssues(buf.toString(), warnings);
                    line = reader.readLine();
                    continue;
                }
                m = pOutput.matcher(line);
                if (m.matches()) {
                    this.findIssues(preProcessor.apply(line), warnings);
                }
                line = reader.readLine();
            }
            Report report = warnings;
            return report;
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder toolTipBuilder = new StringBuilder();
        String filePath = "Nil";
        int lineNumber = 0;
        String category = "Kernel Output";
        Severity priority = Severity.WARNING_LOW;
        String bug = matcher.group(3);
        String kern = matcher.group(6);
        if (kern != null) {
            String stripped = this.removeTimestamp(kern);
            messageBuilder.append(stripped);
        } else if (bug != null) {
            Matcher pathMatcher = FILE_PATH_PATTERN.matcher(bug);
            if (pathMatcher.find()) {
                category = pathMatcher.group(1).trim();
                filePath = pathMatcher.group(3).trim();
                lineNumber = this.parseInt(pathMatcher.group(4));
                priority = "BUG".equals(category) ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
                messageBuilder.append(category);
                messageBuilder.append(" in ");
                messageBuilder.append(pathMatcher.group(5).trim());
                messageBuilder.append("()");
                toolTipBuilder.append("------------[ cut here ]------------\n");
                toolTipBuilder.append(this.removeTimestamp(bug));
                toolTipBuilder.append('\n');
                toolTipBuilder.append(matcher.group(4));
                toolTipBuilder.append('\n');
            } else {
                messageBuilder.append(this.removeTimestamp(bug));
            }
        } else {
            return FALSE_POSITIVE;
        }
        String message = messageBuilder.length() == 0 ? "Unknown Error" : messageBuilder.toString().replace("\n", "<br>");
        builder.setFileName(filePath).setLineStart(lineNumber).setCategory(category).setMessage(message).setSeverity(priority);
        if (toolTipBuilder.length() > 0) {
            builder.setDescription(toolTipBuilder.toString().replace("\n", "<br>"));
        }
        return builder.build();
    }

    private String removeTimestamp(String bug) {
        return TIMESTAMP_PATTERN.matcher(bug).replaceAll("").trim();
    }
}

