/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class P4Parser
extends FastRegexpLineParser {
    private static final long serialVersionUID = -8106854254745366432L;
    private static final String ALREADY_OPENED = "already opened for edit";
    private static final String CANT_ADD = "can't add existing file";
    private static final String WARNING_ADD_OF = "warning: add of existing file";
    private static final String OPENED_FOR_EDIT = "can't add \\(already opened for edit\\)";
    private static final String NOTHING_CHANGED = "nothing changed";
    private static final String OR = "|";
    private static final String PERFORCE_WARNING_PATTERN = "^(.*) - (can't add existing file|warning: add of existing file|can't add \\(already opened for edit\\)|nothing changed)(.*)$";

    public P4Parser() {
        super(PERFORCE_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String category = matcher.group(2).trim();
        Severity p = this.mapPriority(category);
        return builder.setFileName(matcher.group(1).trim()).setLineStart(0).setCategory(category).setMessage(matcher.group(1).trim()).setSeverity(p).build();
    }

    private Severity mapPriority(String category) {
        if (category.contains(ALREADY_OPENED) || category.equals(NOTHING_CHANGED)) {
            return Severity.WARNING_LOW;
        }
        return Severity.WARNING_NORMAL;
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(" - ");
    }
}

