/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class Pep8Parser
extends FastRegexpLineParser {
    private static final long serialVersionUID = -8444940209330966997L;
    private static final String PEP8_WARNING_PATTERN = "(.*):(\\d+):(\\d+): (\\D\\d*) (.*)";

    public Pep8Parser() {
        super(PEP8_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(5);
        String category = this.guessCategoryIfEmpty(matcher.group(4), message);
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setColumnStart(this.parseInt(matcher.group(3))).setCategory(category).setMessage(message).setSeverity(this.mapPriority(category)).build();
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(":");
    }

    private Severity mapPriority(String priority) {
        if (priority.contains("E")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }
}

