/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class PerlCriticParser
extends RegexpLineParser {
    private static final long serialVersionUID = -6481203155449490873L;
    private static final String PERLCRITIC_WARNING_PATTERN = "(?:(.*?):)?(.*)\\s+at\\s+line\\s+(\\d+),\\s+column\\s+(\\d+)\\.\\s*(?:See page[s]?\\s+)?(.*)\\.\\s*\\(?Severity:\\s*(\\d)\\)?";

    public PerlCriticParser() {
        super(PERLCRITIC_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String filename = matcher.group(1) == null ? "-" : matcher.group(1);
        String message = matcher.group(2);
        int line = this.parseInt(matcher.group(3));
        int column = this.parseInt(matcher.group(4));
        String category = matcher.group(5);
        Severity priority = this.checkPriority(Integer.parseInt(matcher.group(6)));
        return builder.setFileName(filename).setLineStart(line).setColumnStart(column).setCategory(category).setMessage(message).setSeverity(priority).build();
    }

    private Severity checkPriority(int priority) {
        if (priority < 2) {
            return Severity.WARNING_LOW;
        }
        if (priority < 4) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }
}

