/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class QacSourceCodeAnalyserParser
extends RegexpLineParser {
    private static final long serialVersionUID = -8104046102312005968L;
    private static final String QAC_WARNING_PATTERN = "^(.+?)\\((\\d+),(\\d+)\\): (Err|Msg)\\((\\d+):(\\d+)\\) (.+?)$";

    public QacSourceCodeAnalyserParser() {
        super(QAC_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String category;
        Severity priority;
        if ("err".equalsIgnoreCase(matcher.group(4))) {
            priority = Severity.WARNING_HIGH;
            category = "ERROR";
        } else {
            priority = Severity.WARNING_NORMAL;
            category = "Warning";
        }
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setCategory(category).setMessage(matcher.group(7)).setSeverity(priority).build();
    }
}

