/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class RfLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = -7903991158616386226L;
    private static final String RFLINT_ERROR_PATTERN = "([W|E|I]): (\\d+), (\\d+): (.*) \\((.*)\\)";
    private static final String RFLINT_FILE_PATTERN = "\\+\\s(.*)";
    private String fileName = "";

    public RfLintParser() {
        super(RFLINT_ERROR_PATTERN);
    }

    @Override
    public Report parse(Reader file, Function<String, String> preProcessor) {
        Report warnings = new Report();
        try (LineIterator iterator = IOUtils.lineIterator((Reader)file);){
            Pattern filePattern = Pattern.compile(RFLINT_FILE_PATTERN);
            while (iterator.hasNext()) {
                String line = preProcessor.apply(iterator.nextLine());
                Matcher matcher = filePattern.matcher(line);
                if (matcher.find()) {
                    this.fileName = matcher.group(1);
                }
                this.findIssues(line, warnings);
            }
        }
        catch (IOException exception) {
            throw new ParsingException(exception, "Can't read input lines");
        }
        return warnings;
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(4);
        String category = this.guessCategoryIfEmpty(matcher.group(1), message);
        Severity priority = Severity.WARNING_LOW;
        switch (category.charAt(0)) {
            case 'E': {
                priority = Severity.WARNING_HIGH;
                category = "ERROR";
                break;
            }
            case 'W': {
                priority = Severity.WARNING_NORMAL;
                category = "WARNING";
                break;
            }
            case 'I': {
                priority = Severity.WARNING_LOW;
                category = "IGNORE";
                break;
            }
        }
        return builder.setFileName(this.fileName).setLineStart(this.parseInt(matcher.group(2))).setCategory(category).setMessage(message).setSeverity(priority).build();
    }
}

