/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class SbtScalacParser
extends RegexpLineParser {
    private static final long serialVersionUID = -4233964844965517977L;
    private static final String SBT_WARNING_PATTERN = "^(\\[warn\\]|\\[error\\])\\s*(.*?):(\\d+)(?::\\d+)?:\\s*(.*)$";

    public SbtScalacParser() {
        super(SBT_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        return builder.setFileName(matcher.group(2)).setLineStart(this.parseInt(matcher.group(3))).setMessage(matcher.group(4)).setSeverity(this.mapPriority(matcher)).build();
    }

    private Severity mapPriority(Matcher matcher) {
        if ("[error]".equals(matcher.group(1))) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

