/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XlcLinkerParser
extends RegexpLineParser {
    private static final long serialVersionUID = 211259620936831096L;
    private static final String XLC_LINKER_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)*\\s*(.*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_ERROR_1 = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+).*ERROR:\\s*(.*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_ERROR_2 = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(Error .*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_WARNING = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*WARNING:\\s*(.*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_INFO = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(.*)$";
    private static final Pattern PATTERN_ERROR_1 = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+).*ERROR:\\s*(.*)$");
    private static final Pattern PATTERN_ERROR_2 = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(Error .*)$");
    private static final Pattern PATTERN_WARNING = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*WARNING:\\s*(.*)$");
    private static final Pattern PATTERN_INFO = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(.*)$");

    public XlcLinkerParser() {
        super(XLC_LINKER_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String line = matcher.group(0);
        builder.setFileName("").setLineStart(0);
        Matcher lineMatcher = PATTERN_ERROR_1.matcher(line);
        if (lineMatcher.find()) {
            String category = lineMatcher.group(1);
            String message = lineMatcher.group(2);
            return builder.setCategory(category).setMessage(message).setSeverity(Severity.WARNING_HIGH).build();
        }
        lineMatcher = PATTERN_ERROR_2.matcher(line);
        if (lineMatcher.find()) {
            String category = lineMatcher.group(1);
            String message = lineMatcher.group(2);
            return builder.setCategory(category).setMessage(message).setSeverity(Severity.WARNING_HIGH).build();
        }
        lineMatcher = PATTERN_WARNING.matcher(line);
        if (lineMatcher.find()) {
            String category = lineMatcher.group(1);
            String message = lineMatcher.group(2);
            return builder.setCategory(category).setMessage(message).setSeverity(Severity.WARNING_NORMAL).build();
        }
        lineMatcher = PATTERN_INFO.matcher(line);
        if (lineMatcher.find()) {
            String category = lineMatcher.group(1);
            String message = lineMatcher.group(2);
            return builder.setCategory(category).setMessage(message).setSeverity(Severity.WARNING_LOW).build();
        }
        return FALSE_POSITIVE;
    }
}

