/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.checkstyle;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.checkstyle.CheckStyle;
import edu.hm.hafner.analysis.parser.checkstyle.Error;
import edu.hm.hafner.analysis.parser.checkstyle.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CheckStyleParser
extends AbstractParser {
    private static final long serialVersionUID = -3187275729854832128L;

    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        try {
            SecureDigester digester = new SecureDigester(CheckStyleParser.class);
            String rootXPath = "checkstyle";
            digester.addObjectCreate(rootXPath, CheckStyle.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "checkstyle/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "checkstyle/file/error";
            digester.addObjectCreate(bugXPath, Error.class);
            digester.addSetProperties(bugXPath);
            digester.addSetNext(bugXPath, "addError", Error.class.getName());
            CheckStyle checkStyle = (CheckStyle)digester.parse(reader);
            if (checkStyle == null) {
                throw new ParsingException("Input stream is not a Checkstyle file.");
            }
            return this.convert(checkStyle);
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    private Report convert(CheckStyle collection) {
        Report report = new Report();
        for (File file : collection.getFiles()) {
            if (!this.isValidWarning(file)) continue;
            for (Error error : file.getErrors()) {
                IssueBuilder builder = new IssueBuilder();
                this.mapPriority(error).ifPresent(builder::setSeverity);
                String source = error.getSource();
                builder.setType(this.getType(source));
                builder.setCategory(this.getCategory(source));
                builder.setMessage(error.getMessage());
                builder.setLineStart(error.getLine());
                builder.setFileName(file.getName());
                builder.setColumnStart(error.getColumn());
                report.add(builder.build());
            }
        }
        return report;
    }

    private String getCategory(String source) {
        return StringUtils.capitalize((String)this.getType(StringUtils.substringBeforeLast((String)source, (String)".")));
    }

    private String getType(String source) {
        return StringUtils.substringAfterLast((String)source, (String)".");
    }

    private Optional<Severity> mapPriority(Error error) {
        if ("error".equalsIgnoreCase(error.getSeverity())) {
            return Optional.of(Severity.WARNING_HIGH);
        }
        if ("warning".equalsIgnoreCase(error.getSeverity())) {
            return Optional.of(Severity.WARNING_NORMAL);
        }
        if ("info".equalsIgnoreCase(error.getSeverity())) {
            return Optional.of(Severity.WARNING_LOW);
        }
        return Optional.empty();
    }

    private boolean isValidWarning(File file) {
        return !file.getName().endsWith("package.html");
    }
}

