/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.dry;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.digester3.Digester;
import org.xml.sax.SAXException;

public abstract class AbstractDryParser<T>
extends AbstractParser {
    private static final long serialVersionUID = 6328121785037117886L;
    private final int highThreshold;
    private final int normalThreshold;

    protected AbstractDryParser(int highThreshold, int normalThreshold) {
        this.highThreshold = highThreshold;
        this.normalThreshold = normalThreshold;
    }

    protected Severity getPriority(int lines) {
        if (lines >= this.highThreshold) {
            return Severity.WARNING_HIGH;
        }
        if (lines >= this.normalThreshold) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        try {
            SecureDigester digester = new SecureDigester(AbstractDryParser.class);
            this.configureParser(digester);
            ArrayList duplications = new ArrayList();
            digester.push(duplications);
            Object result = digester.parse(reader);
            if (result != duplications) {
                throw new ParsingException("Input stream is not a valid duplications file.");
            }
            return this.convertDuplicationsToIssues(duplications);
        }
        catch (IOException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    protected abstract void configureParser(Digester var1);

    protected abstract Report convertDuplicationsToIssues(List<T> var1);
}

