/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;

public final class Ensure {
    public static BooleanCondition that(boolean value) {
        return new BooleanCondition(value);
    }

    public static ObjectCondition that(@CheckForNull Object value, Object ... additionalValues) {
        return new ObjectCondition(value, additionalValues);
    }

    public static IterableCondition that(@CheckForNull Iterable<?> value) {
        return new IterableCondition(value);
    }

    public static CollectionCondition that(@CheckForNull Collection<?> value) {
        return new CollectionCondition(value);
    }

    public static ArrayCondition that(@CheckForNull Object[] value) {
        return new ArrayCondition(value);
    }

    public static StringCondition that(@CheckForNull String value) {
        return new StringCondition(value);
    }

    public static ExceptionCondition that(@CheckForNull Throwable value) {
        return new ExceptionCondition(value);
    }

    public static void thatStatementIsNeverReached() {
        Ensure.throwException("This statement should never be reached.", new Object[0]);
    }

    @FormatMethod
    public static void thatStatementIsNeverReached(String explanation, Object ... args) {
        Ensure.throwException(explanation, args);
    }

    @FormatMethod
    private static void throwException(String message, Object ... args) {
        throw new AssertionError((Object)String.format(message, args));
    }

    @FormatMethod
    private static void throwNullPointerException(String message, Object ... args) {
        throw new NullPointerException(String.format(message, args));
    }

    private Ensure() {
    }

    public static class ExceptionCondition {
        private final Throwable value;

        public ExceptionCondition(@CheckForNull Throwable value) {
            this.value = value;
        }

        @FormatMethod
        public void isNeverThrown(String explanation, Object ... args) {
            throw new AssertionError(String.format(explanation, args), this.value);
        }
    }

    public static class BooleanCondition {
        private final boolean value;

        public BooleanCondition(boolean value) {
            this.value = value;
        }

        @FormatMethod
        public void isFalse(String explanation, Object ... args) {
            if (this.value) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isFalse() {
            this.isFalse("Value is not FALSE", new Object[0]);
        }

        @FormatMethod
        public void isTrue(String explanation, Object ... args) {
            if (!this.value) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isTrue() {
            this.isTrue("Value is not TRUE", new Object[0]);
        }
    }

    public static class ObjectCondition {
        private final Object value;
        private final Object[] additionalValues;

        public ObjectCondition(@CheckForNull Object value) {
            this(value, new Object[0]);
        }

        @SuppressFBWarnings(value={"EI2"})
        public ObjectCondition(@CheckForNull Object value, @CheckForNull Object[] additionalValues) {
            this.value = value;
            this.additionalValues = additionalValues;
        }

        public void isNotNull() {
            this.isNotNull("Object is NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotNull(String explanation, Object ... args) {
            if (this.value == null) {
                Ensure.throwNullPointerException(explanation, args);
            }
            for (Object additionalValue : this.additionalValues) {
                if (additionalValue != null) continue;
                Ensure.throwNullPointerException(explanation, args);
            }
        }

        public void isNull() {
            this.isNull("Object is not NULL", new Object[0]);
        }

        @FormatMethod
        public void isNull(String explanation, Object ... args) {
            if (this.value != null) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isInstanceOf(Class<?> type, Class<?> ... additionalTypes) {
            this.isNotNull();
            MutableList types = Lists.mutable.of((Object[])additionalTypes);
            types.add(type);
            for (Class clazz : types) {
                if (!clazz.isInstance(this.value)) continue;
                return;
            }
            Ensure.throwException("Object is of wrong type. Actual: %s. Expected one of: %s", new Object[]{this.value, types});
        }

        @FormatMethod
        public void isInstanceOf(Class<?> type, String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (!type.isInstance(this.value)) {
                Ensure.throwException(explanation, args);
            }
        }
    }

    public static class StringCondition
    extends ObjectCondition {
        private final String value;

        public StringCondition(@CheckForNull String value) {
            super(value);
            this.value = value;
        }

        public void isNotEmpty() {
            this.isNotEmpty("The string is empty or NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotEmpty(String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.value.isEmpty()) {
                Ensure.throwException(explanation, args);
            }
        }

        public void isNotBlank() {
            this.isNotBlank("The string is blank", new Object[0]);
        }

        @FormatMethod
        public void isNotBlank(String explanation, Object ... args) {
            this.isNotNull();
            if (this.isBlank()) {
                Ensure.throwException(explanation, args);
            }
        }

        private boolean isBlank() {
            if (this.value.isEmpty()) {
                return true;
            }
            for (int i = 0; i < this.value.length(); ++i) {
                if (Character.isWhitespace(this.value.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class ArrayCondition
    extends ObjectCondition {
        private final Object[] values;

        @SuppressFBWarnings(value={"EI2"})
        public ArrayCondition(@CheckForNull Object[] values) {
            super(values);
            this.values = values;
        }

        public void isNotEmpty() {
            this.isNotEmpty("Array is empty or NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotEmpty(String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.values.length == 0) {
                Ensure.throwException(explanation, args);
            } else {
                for (Object object : this.values) {
                    if (object != null) continue;
                    Ensure.throwException(explanation, args);
                }
            }
        }
    }

    public static class CollectionCondition
    extends IterableCondition {
        private final Collection<?> value;

        public CollectionCondition(@CheckForNull Collection<?> value) {
            super(value);
            this.value = value;
        }

        public void contains(Object element) {
            this.contains(element, "Collection %s does not contain element '%s'", this.value, element);
        }

        @FormatMethod
        public void contains(Object element, String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (!this.value.contains(element)) {
                Ensure.throwException(explanation, args);
            }
        }

        public void doesNotContain(Object element) {
            this.doesNotContain(element, "Collection '%s' contains element '%s'", this.value, element);
        }

        @FormatMethod
        public void doesNotContain(Object element, String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.value.contains(element)) {
                Ensure.throwException(explanation, args);
            }
        }
    }

    public static class IterableCondition
    extends ObjectCondition {
        private final Iterable<?> value;

        public IterableCondition(@CheckForNull Iterable<?> value) {
            super(value);
            this.value = value;
        }

        public void isNotEmpty() {
            this.isNotEmpty("Iterable is empty or NULL", new Object[0]);
        }

        @FormatMethod
        public void isNotEmpty(String explanation, Object ... args) {
            this.isNotNull(explanation, args);
            if (this.value.iterator().hasNext()) {
                for (Object object : this.value) {
                    if (object != null) continue;
                    Ensure.throwException(explanation, args);
                }
            } else {
                Ensure.throwException(explanation, args);
            }
        }
    }
}

