/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.PackageDetectors;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.input.BOMInputStream;

abstract class AbstractPackageDetector {
    private final PackageDetectors.FileSystem fileSystem;

    AbstractPackageDetector(PackageDetectors.FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String detectPackageName(String fileName, Charset charset) {
        if (this.accepts(fileName)) {
            String string;
            block9: {
                InputStream stream = this.fileSystem.openFile(fileName);
                try {
                    string = this.detectPackageName(stream, charset);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | InvalidPathException exception) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return string;
        }
        return "-";
    }

    @VisibleForTesting
    String detectPackageName(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(stream), charset));){
            String string = this.detectPackageName(buffer.lines());
            return string;
        }
    }

    String detectPackageName(Stream<String> lines) {
        Pattern pattern = this.getPattern();
        return lines.map(pattern::matcher).filter(Matcher::matches).findFirst().map(matcher -> matcher.group(1)).orElse("-").trim();
    }

    abstract Pattern getPattern();

    abstract boolean accepts(String var1);
}

