/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractModuleDetector;
import edu.hm.hafner.analysis.ModuleDetector;
import edu.hm.hafner.analysis.SecureDigester;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class AntModuleDetector
extends AbstractModuleDetector {
    static final String ANT_PROJECT = "build.xml";

    AntModuleDetector(ModuleDetector.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    String getPattern() {
        return "**/build.xml";
    }

    @Override
    void collectProjects(Map<String, String> mapping, List<String> projects) {
        for (String fileName : projects) {
            if (!fileName.endsWith(ANT_PROJECT)) continue;
            this.addMapping(mapping, fileName, ANT_PROJECT, this.parseBuildXml(fileName));
        }
    }

    private String parseBuildXml(String buildXml) {
        String string;
        block8: {
            InputStream file = this.getFactory().open(buildXml);
            try {
                SecureDigester digester = new SecureDigester(ModuleDetector.class);
                digester.push(new StringBuilder());
                String xPath = "project";
                digester.addCallMethod(xPath, "append", 1);
                digester.addCallParam(xPath, 0, "name");
                StringBuilder result = (StringBuilder)digester.parse(file);
                string = result.toString();
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException | SAXException exception) {
                    return "";
                }
            }
            file.close();
        }
        return string;
    }
}

