/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractModuleDetector;
import edu.hm.hafner.analysis.ModuleDetector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class GradleModuleDetector
extends AbstractModuleDetector {
    static final String BUILD_GRADLE = "build.gradle";
    static final String BUILD_GRADLE_KTS = "build.gradle.kts";
    static final String SETTINGS_GRADLE = "settings.gradle";
    static final String SETTINGS_GRADLE_KTS = "settings.gradle.kts";
    private static final Pattern RE_GRADLE_SET_PROJECT_NAME = Pattern.compile("^\\s*rootProject\\.(name\\s*=|setName\\(?)\\s*['\"]([^'\"]*)['\"]\\)?");

    GradleModuleDetector(ModuleDetector.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    String getPattern() {
        return "**/settings.gradle, **/settings.gradle.kts";
    }

    @Override
    public void collectProjects(Map<String, String> mapping, List<String> projects) {
        for (String fileName : projects) {
            if (fileName.endsWith(BUILD_GRADLE) || fileName.endsWith(BUILD_GRADLE_KTS)) {
                this.addMapping(mapping, fileName, BUILD_GRADLE, this.parseGradle(fileName));
                continue;
            }
            if (!fileName.endsWith(SETTINGS_GRADLE) && !fileName.endsWith(SETTINGS_GRADLE_KTS)) continue;
            this.addMapping(mapping, fileName, SETTINGS_GRADLE, this.parseGradleSettings(fileName));
        }
    }

    private String parseGradle(String buildScript) {
        String basePath = FilenameUtils.getPathNoEndSeparator((String)buildScript);
        String parentDirName = FilenameUtils.getName((String)basePath);
        return StringUtils.trimToEmpty((String)parentDirName);
    }

    private String parseGradleSettings(String settingsFile) {
        String name = null;
        try (InputStream input = this.getFactory().open(settingsFile);
             Scanner scan = new Scanner(input, "UTF-8");){
            while (scan.hasNextLine()) {
                String line = scan.findInLine(RE_GRADLE_SET_PROJECT_NAME);
                if (line != null) {
                    name = scan.match().group(2);
                    break;
                }
                scan.nextLine();
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        return (String)StringUtils.defaultIfBlank(name, (CharSequence)"");
    }
}

