/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class IssueParser
implements Serializable {
    private static final long serialVersionUID = 200992696185460268L;
    protected static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    protected static final String CATEGORY = "category";
    protected static final String COLUMN_END = "columnEnd";
    protected static final String COLUMN_START = "columnStart";
    protected static final String DESCRIPTION = "description";
    protected static final String FILE_NAME = "fileName";
    protected static final String FINGERPRINT = "fingerprint";
    protected static final String ID = "id";
    protected static final String LINE_END = "lineEnd";
    protected static final String LINE_RANGES = "lineRanges";
    protected static final String LINE_RANGE_END = "end";
    protected static final String LINE_RANGE_START = "start";
    protected static final String LINE_START = "lineStart";
    protected static final String MESSAGE = "message";
    protected static final String MODULE_NAME = "moduleName";
    protected static final String ORIGIN = "origin";
    protected static final String PACKAGE_NAME = "packageName";
    protected static final String SEVERITY = "severity";
    protected static final String TYPE = "type";

    public abstract Report parse(ReaderFactory var1) throws ParsingException, ParsingCanceledException;

    public Report parseFile(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        Report report = this.parse(readerFactory);
        report.setOriginReportFile(readerFactory.getFileName());
        return report;
    }

    public boolean accepts(ReaderFactory readerFactory) {
        return true;
    }

    protected boolean isXmlFile(ReaderFactory readerFactory) {
        boolean bl;
        block8: {
            Stream<String> lines = readerFactory.readStream();
            try {
                bl = lines.limit(10L).anyMatch(line -> line.contains("<?xml"));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParsingException | SecureXmlParserFactory.ParsingException ignored) {
                    return false;
                }
            }
            lines.close();
        }
        return bl;
    }

    public static boolean equalsIgnoreCase(@CheckForNull String a, @CheckForNull String b) {
        return StringUtils.equals((CharSequence)IssueParser.normalize(a), (CharSequence)IssueParser.normalize(b));
    }

    private static String normalize(@CheckForNull String input) {
        return StringUtils.defaultString((String)input).toUpperCase(Locale.ENGLISH);
    }
}

